/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import org.apache.hc.client5.http.HttpRequestRetryHandler;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.classic.ClassicRequestCopier;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class RetryExec
implements ExecChainHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(HttpRequestRetryHandler retryHandler) {
        Args.notNull((Object)retryHandler, (String)"HTTP request retry handler");
        this.retryHandler = retryHandler;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        ClassicHttpRequest currentRequest = request;
        int execCount = 1;
        while (true) {
            try {
                return chain.proceed(currentRequest, scope);
            }
            catch (IOException ex) {
                if (scope.execRuntime.isExecutionAborted()) {
                    throw new RequestFailedException("Request aborted");
                }
                HttpEntity requestEntity = request.getEntity();
                if (requestEntity != null && !requestEntity.isRepeatable()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(exchangeId + ": cannot retry non-repeatable request");
                    }
                    throw ex;
                }
                if (this.retryHandler.retryRequest((HttpRequest)request, ex, execCount, (HttpContext)context)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(exchangeId + ": " + ex.getMessage(), (Throwable)ex);
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Recoverable I/O exception (" + ex.getClass().getName() + ") " + "caught when processing request to " + route);
                    }
                } else {
                    if (ex instanceof NoHttpResponseException) {
                        NoHttpResponseException updatedex = new NoHttpResponseException(route.getTargetHost().toHostString() + " failed to respond");
                        updatedex.setStackTrace(ex.getStackTrace());
                        throw updatedex;
                    }
                    throw ex;
                }
                currentRequest = ClassicRequestCopier.INSTANCE.copy(scope.originalRequest);
                ++execCount;
                continue;
            }
            break;
        }
    }
}

