/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MultihomeIOSessionRequester {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DnsResolver dnsResolver;

    MultihomeIOSessionRequester(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    public Future<IOSession> connect(final ConnectionInitiator connectionInitiator, final NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, final SocketAddress localAddress, final Timeout connectTimeout, final Object attachment, FutureCallback<IOSession> callback) {
        InetAddress[] remoteAddresses;
        if (remoteAddress != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(remoteEndpoint + ": connecting " + localAddress + " to " + remoteAddress + " (" + connectTimeout + ")");
            }
            return connectionInitiator.connect(remoteEndpoint, remoteAddress, localAddress, connectTimeout, attachment, callback);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(remoteEndpoint + ": resolving remote address");
        }
        final ComplexFuture future = new ComplexFuture(callback);
        try {
            remoteAddresses = this.dnsResolver.resolve(remoteEndpoint.getHostName());
        }
        catch (UnknownHostException ex) {
            future.failed((Exception)ex);
            return future;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(remoteEndpoint + ": resolved to " + Arrays.asList(remoteAddresses));
        }
        Runnable runnable = new Runnable(){
            private final AtomicInteger attempt = new AtomicInteger(0);

            void executeNext() {
                int index = this.attempt.getAndIncrement();
                final InetSocketAddress remoteAddress = new InetSocketAddress(remoteAddresses[index], remoteEndpoint.getPort());
                if (MultihomeIOSessionRequester.this.log.isDebugEnabled()) {
                    MultihomeIOSessionRequester.this.log.debug(remoteEndpoint + ": connecting " + localAddress + " to " + remoteAddress + " (" + connectTimeout + ")");
                }
                Future sessionFuture = connectionInitiator.connect(remoteEndpoint, (SocketAddress)remoteAddress, localAddress, connectTimeout, attachment, (FutureCallback)new FutureCallback<IOSession>(){

                    public void completed(IOSession session) {
                        if (MultihomeIOSessionRequester.this.log.isDebugEnabled() && MultihomeIOSessionRequester.this.log.isDebugEnabled()) {
                            MultihomeIOSessionRequester.this.log.debug(remoteEndpoint + ": connected " + session.getId() + " " + session.getLocalAddress() + "->" + session.getRemoteAddress());
                        }
                        future.completed((Object)session);
                    }

                    public void failed(Exception cause) {
                        if (attempt.get() >= remoteAddresses.length) {
                            if (MultihomeIOSessionRequester.this.log.isDebugEnabled()) {
                                MultihomeIOSessionRequester.this.log.debug(remoteEndpoint + ": connection to " + remoteAddress + " failed " + "(" + cause.getClass() + "); terminating operation");
                            }
                            if (cause instanceof IOException) {
                                future.failed((Exception)new HttpHostConnectException((IOException)cause, remoteEndpoint, remoteAddresses));
                            } else {
                                future.failed(cause);
                            }
                        } else {
                            if (MultihomeIOSessionRequester.this.log.isDebugEnabled()) {
                                MultihomeIOSessionRequester.this.log.debug(remoteEndpoint + ": connection to " + remoteAddress + " failed " + "(" + cause.getClass() + "); retrying connection to the next address");
                            }
                            this.executeNext();
                        }
                    }

                    public void cancelled() {
                        future.cancel();
                    }
                });
                future.setDependency(sessionFuture);
            }

            @Override
            public void run() {
                this.executeNext();
            }
        };
        runnable.run();
        return future;
    }

    public Future<IOSession> connect(ConnectionInitiator connectionInitiator, NamedEndpoint remoteEndpoint, SocketAddress localAddress, Timeout connectTimeout, Object attachment, FutureCallback<IOSession> callback) {
        return this.connect(connectionInitiator, remoteEndpoint, null, localAddress, connectTimeout, attachment, callback);
    }
}

