/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.NTUserPrincipal;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.junit.Assert;
import org.junit.Test;

public class TestCredentials {
    @Test
    public void testUsernamePasswordCredentialsBasics() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd");
        Assert.assertEquals((Object)"name", (Object)creds1.getUserName());
        Assert.assertEquals((Object)new BasicUserPrincipal("name"), (Object)creds1.getUserPrincipal());
        Assert.assertEquals((Object)"pwd", (Object)creds1.getPassword());
        Assert.assertEquals((Object)"[principal: name]", (Object)creds1.toString());
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("name:pwd");
        Assert.assertEquals((Object)"name", (Object)creds2.getUserName());
        Assert.assertEquals((Object)new BasicUserPrincipal("name"), (Object)creds2.getUserPrincipal());
        Assert.assertEquals((Object)"pwd", (Object)creds2.getPassword());
        Assert.assertEquals((Object)"[principal: name]", (Object)creds2.toString());
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name");
        Assert.assertEquals((Object)"name", (Object)creds3.getUserName());
        Assert.assertEquals((Object)new BasicUserPrincipal("name"), (Object)creds3.getUserPrincipal());
        Assert.assertEquals(null, (Object)creds3.getPassword());
        Assert.assertEquals((Object)"[principal: name]", (Object)creds3.toString());
    }

    @Test
    public void testNTCredentialsBasics() {
        NTCredentials creds1 = new NTCredentials("name", "pwd", "localhost", "domain");
        Assert.assertEquals((Object)"name", (Object)creds1.getUserName());
        Assert.assertEquals((Object)new NTUserPrincipal("DOMAIN", "name"), (Object)creds1.getUserPrincipal());
        Assert.assertEquals((Object)"pwd", (Object)creds1.getPassword());
        Assert.assertEquals((Object)"[principal: DOMAIN/name][workstation: LOCALHOST]", (Object)creds1.toString());
        NTCredentials creds2 = new NTCredentials("name", null, null, null);
        Assert.assertEquals((Object)"name", (Object)creds2.getUserName());
        Assert.assertEquals((Object)new NTUserPrincipal(null, "name"), (Object)creds2.getUserPrincipal());
        Assert.assertEquals(null, (Object)creds2.getPassword());
        Assert.assertEquals((Object)"[principal: name][workstation: null]", (Object)creds2.toString());
        NTCredentials creds3 = new NTCredentials("domain/name:pwd");
        Assert.assertEquals((Object)"name", (Object)creds3.getUserName());
        Assert.assertEquals((Object)new NTUserPrincipal("DOMAIN", "name"), (Object)creds3.getUserPrincipal());
        Assert.assertEquals((Object)"pwd", (Object)creds3.getPassword());
        Assert.assertEquals((Object)"[principal: DOMAIN/name][workstation: null]", (Object)creds3.toString());
        NTCredentials creds4 = new NTCredentials("domain/name");
        Assert.assertEquals((Object)"name", (Object)creds4.getUserName());
        Assert.assertEquals((Object)new NTUserPrincipal("DOMAIN", "name"), (Object)creds4.getUserPrincipal());
        Assert.assertEquals(null, (Object)creds4.getPassword());
        Assert.assertEquals((Object)"[principal: DOMAIN/name][workstation: null]", (Object)creds4.toString());
        NTCredentials creds5 = new NTCredentials("name");
        Assert.assertEquals((Object)"name", (Object)creds5.getUserName());
        Assert.assertEquals((Object)new NTUserPrincipal(null, "name"), (Object)creds5.getUserPrincipal());
        Assert.assertEquals(null, (Object)creds5.getPassword());
        Assert.assertEquals((Object)"[principal: name][workstation: null]", (Object)creds5.toString());
    }

    @Test
    public void testUsernamePasswordCredentialsHashCode() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd");
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("othername", "pwd");
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name", "otherpwd");
        Assert.assertTrue((creds1.hashCode() == creds1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() != creds2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() == creds3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUsernamePasswordCredentialsEquals() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name", "pwd");
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("othername", "pwd");
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name", "otherpwd");
        Assert.assertTrue((boolean)creds1.equals((Object)creds1));
        Assert.assertFalse((boolean)creds1.equals((Object)creds2));
        Assert.assertTrue((boolean)creds1.equals((Object)creds3));
    }

    @Test
    public void testNTCredentialsHashCode() {
        NTCredentials creds1 = new NTCredentials("name", "pwd", "somehost", "domain");
        NTCredentials creds2 = new NTCredentials("othername", "pwd", "somehost", "domain");
        NTCredentials creds3 = new NTCredentials("name", "otherpwd", "SomeHost", "Domain");
        NTCredentials creds4 = new NTCredentials("name", "pwd", "otherhost", "domain");
        NTCredentials creds5 = new NTCredentials("name", "pwd", null, "domain");
        NTCredentials creds6 = new NTCredentials("name", "pwd", "somehost", "ms");
        NTCredentials creds7 = new NTCredentials("name", "pwd", "somehost", null);
        NTCredentials creds8 = new NTCredentials("name", "pwd", null, "domain");
        NTCredentials creds9 = new NTCredentials("name", "pwd", "somehost", null);
        Assert.assertTrue((creds1.hashCode() == creds1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() != creds2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds1.hashCode() == creds3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds6.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((creds1.hashCode() == creds7.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds8.hashCode() == creds5.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((creds9.hashCode() == creds7.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testNTCredentialsEquals() {
        NTCredentials creds1 = new NTCredentials("name", "pwd", "somehost", "domain");
        NTCredentials creds2 = new NTCredentials("othername", "pwd", "somehost", "domain");
        NTCredentials creds3 = new NTCredentials("name", "otherpwd", "SomeHost", "Domain");
        NTCredentials creds4 = new NTCredentials("name", "pwd", "otherhost", "domain");
        NTCredentials creds5 = new NTCredentials("name", "pwd", null, "domain");
        NTCredentials creds6 = new NTCredentials("name", "pwd", "somehost", "ms");
        NTCredentials creds7 = new NTCredentials("name", "pwd", "somehost", null);
        NTCredentials creds8 = new NTCredentials("name", "pwd", null, "domain");
        NTCredentials creds9 = new NTCredentials("name", "pwd", "somehost", null);
        Assert.assertTrue((boolean)creds1.equals((Object)creds1));
        Assert.assertFalse((boolean)creds1.equals((Object)creds2));
        Assert.assertTrue((boolean)creds1.equals((Object)creds3));
        Assert.assertFalse((boolean)creds1.equals((Object)creds4));
        Assert.assertFalse((boolean)creds1.equals((Object)creds5));
        Assert.assertFalse((boolean)creds1.equals((Object)creds6));
        Assert.assertFalse((boolean)creds1.equals((Object)creds7));
        Assert.assertTrue((boolean)creds8.equals((Object)creds5));
        Assert.assertTrue((boolean)creds9.equals((Object)creds7));
    }

    @Test
    public void testUsernamePasswordCredentialsSerialization() throws Exception {
        UsernamePasswordCredentials orig = new UsernamePasswordCredentials("name", "pwd");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outstream = new ObjectOutputStream(outbuffer);
        outstream.writeObject(orig);
        outstream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inbuffer = new ByteArrayInputStream(raw);
        ObjectInputStream instream = new ObjectInputStream(inbuffer);
        UsernamePasswordCredentials clone = (UsernamePasswordCredentials)instream.readObject();
        Assert.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    public void testNTCredentialsSerialization() throws Exception {
        NTCredentials orig = new NTCredentials("name", "pwd", "somehost", "domain");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outstream = new ObjectOutputStream(outbuffer);
        outstream.writeObject(orig);
        outstream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inbuffer = new ByteArrayInputStream(raw);
        ObjectInputStream instream = new ObjectInputStream(inbuffer);
        NTCredentials clone = (NTCredentials)instream.readObject();
        Assert.assertEquals((Object)orig, (Object)clone);
    }
}

