/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import junit.framework.Assert;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.protocol.RequestTargetAuthentication;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Test;

public class TestRequestTargetAuthentication {
    @Test(expected=IllegalArgumentException.class)
    public void testRequestParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process(null, (HttpContext)context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, null);
    }

    @Test
    public void testTargetAuth() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        BasicScheme authscheme = new BasicScheme();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("user", "secret");
        AuthScope authscope = new AuthScope("localhost", 8080, "auth-realm", "http");
        BasicHeader challenge = new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm");
        authscheme.processChallenge((Header)challenge);
        AuthState authstate = new AuthState();
        authstate.setAuthScheme((AuthScheme)authscheme);
        authstate.setAuthScope(authscope);
        authstate.setCredentials((Credentials)creds);
        context.setAttribute("http.auth.target-scope", (Object)authstate);
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Authorization");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"Basic dXNlcjpzZWNyZXQ=", (String)header.getValue());
    }

    @Test
    public void testNoTargetAuthForConnectRequests() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        BasicHttpContext context = new BasicHttpContext();
        BasicScheme authscheme = new BasicScheme();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("user", "secret");
        AuthScope authscope = new AuthScope("localhost", 8080, "auth-realm", "http");
        BasicHeader challenge = new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm");
        authscheme.processChallenge((Header)challenge);
        AuthState authstate = new AuthState();
        authstate.setAuthScheme((AuthScheme)authscheme);
        authstate.setAuthScope(authscope);
        authstate.setCredentials((Credentials)creds);
        context.setAttribute("http.auth.target-scope", (Object)authstate);
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Authorization");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testPreserveAuthHeader() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Authorization", "Basic c3R1ZmY6c3R1ZmY=");
        BasicHttpContext context = new BasicHttpContext();
        BasicScheme authscheme = new BasicScheme();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("user", "secret");
        AuthScope authscope = new AuthScope("localhost", 8080, "auth-realm", "http");
        BasicHeader challenge = new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm");
        authscheme.processChallenge((Header)challenge);
        AuthState authstate = new AuthState();
        authstate.setAuthScheme((AuthScheme)authscheme);
        authstate.setAuthScope(authscope);
        authstate.setCredentials((Credentials)creds);
        context.setAttribute("http.auth.target-scope", (Object)authstate);
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Authorization");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"Basic c3R1ZmY6c3R1ZmY=", (String)header.getValue());
    }

    @Test
    public void testAuthStateNotSet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.target-scope", null);
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Authorization");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testAuthSchemeNotSet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        AuthState authstate = new AuthState();
        context.setAttribute("http.auth.target-scope", (Object)authstate);
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Authorization");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testAuthCredentialsNotSet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        AuthState authstate = new AuthState();
        BasicScheme authscheme = new BasicScheme();
        BasicHeader challenge = new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm");
        authscheme.processChallenge((Header)challenge);
        authstate.setAuthScheme((AuthScheme)authscheme);
        context.setAttribute("http.auth.target-scope", (Object)authstate);
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Authorization");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testConnectionBasedAuthOnlyIfChallenged() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        AuthState authstate = new AuthState();
        BasicScheme authscheme = new BasicScheme(){

            public boolean isConnectionBased() {
                return true;
            }
        };
        BasicHeader challenge = new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm");
        authscheme.processChallenge((Header)challenge);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("user", "secret");
        authstate.setAuthScheme((AuthScheme)authscheme);
        authstate.setCredentials((Credentials)creds);
        authstate.setAuthScope(null);
        context.setAttribute("http.auth.target-scope", (Object)authstate);
        RequestTargetAuthentication interceptor = new RequestTargetAuthentication();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Authorization");
        Assert.assertNull((Object)header);
    }
}

