/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.params;

import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.ClientParamsStack;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.junit.Assert;
import org.junit.Test;

public class TestRouteParams {
    public static final HttpHost TARGET1 = new HttpHost("target1.test.invalid");
    public static final HttpRoute ROUTE1 = new HttpRoute(TARGET1);
    public static final InetAddress LOCAL1;

    @Test
    public void testSetGet() {
        BasicHttpParams params = new BasicHttpParams();
        Assert.assertNull((String)"phantom proxy", (Object)ConnRouteParams.getDefaultProxy((HttpParams)params));
        Assert.assertNull((String)"phantom route", (Object)ConnRouteParams.getForcedRoute((HttpParams)params));
        Assert.assertNull((String)"phantom address", (Object)ConnRouteParams.getLocalAddress((HttpParams)params));
        ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)TARGET1);
        Assert.assertSame((String)"wrong proxy", (Object)TARGET1, (Object)ConnRouteParams.getDefaultProxy((HttpParams)params));
        ConnRouteParams.setForcedRoute((HttpParams)params, (HttpRoute)ROUTE1);
        Assert.assertSame((String)"wrong route", (Object)ROUTE1, (Object)ConnRouteParams.getForcedRoute((HttpParams)params));
        ConnRouteParams.setLocalAddress((HttpParams)params, (InetAddress)LOCAL1);
        Assert.assertSame((String)"wrong address", (Object)LOCAL1, (Object)ConnRouteParams.getLocalAddress((HttpParams)params));
    }

    @Test
    public void testSetNull() {
        BasicHttpParams params = new BasicHttpParams();
        ConnRouteParams.setDefaultProxy((HttpParams)params, null);
        ConnRouteParams.setForcedRoute((HttpParams)params, null);
        ConnRouteParams.setLocalAddress((HttpParams)params, null);
        Assert.assertNull((String)"phantom proxy", (Object)ConnRouteParams.getDefaultProxy((HttpParams)params));
        Assert.assertNull((String)"phantom route", (Object)ConnRouteParams.getForcedRoute((HttpParams)params));
        Assert.assertNull((String)"phantom address", (Object)ConnRouteParams.getLocalAddress((HttpParams)params));
        ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)ConnRouteParams.NO_HOST);
        Assert.assertNull((String)"null proxy not detected", (Object)ConnRouteParams.getDefaultProxy((HttpParams)params));
        ConnRouteParams.setForcedRoute((HttpParams)params, (HttpRoute)ConnRouteParams.NO_ROUTE);
        Assert.assertNull((String)"null route not detected", (Object)ConnRouteParams.getForcedRoute((HttpParams)params));
    }

    @Test
    public void testUnsetHierarchy() {
        BasicHttpParams daddy = new BasicHttpParams();
        BasicHttpParams dummy = new BasicHttpParams();
        BasicHttpParams child = new BasicHttpParams();
        ConnRouteParams.setDefaultProxy((HttpParams)daddy, (HttpHost)TARGET1);
        ConnRouteParams.setDefaultProxy((HttpParams)child, (HttpHost)ConnRouteParams.NO_HOST);
        ClientParamsStack hierarchy = new ClientParamsStack(null, (HttpParams)daddy, (HttpParams)child, null);
        Assert.assertNull((String)"1", (Object)ConnRouteParams.getDefaultProxy((HttpParams)hierarchy));
        hierarchy = new ClientParamsStack(null, (HttpParams)daddy, (HttpParams)new ClientParamsStack(null, (HttpParams)child, (HttpParams)dummy, null), null);
        Assert.assertNull((String)"2", (Object)ConnRouteParams.getDefaultProxy((HttpParams)hierarchy));
        hierarchy = new ClientParamsStack(null, (HttpParams)daddy, (HttpParams)new DefaultedHttpParams((HttpParams)child, (HttpParams)dummy), null);
        Assert.assertNull((String)"3", (Object)ConnRouteParams.getDefaultProxy((HttpParams)hierarchy));
        hierarchy = new DefaultedHttpParams((HttpParams)child, (HttpParams)daddy);
        Assert.assertNull((String)"4", (Object)ConnRouteParams.getDefaultProxy((HttpParams)hierarchy));
        hierarchy = new DefaultedHttpParams((HttpParams)new DefaultedHttpParams((HttpParams)child, (HttpParams)dummy), (HttpParams)daddy);
        Assert.assertNull((String)"5", (Object)ConnRouteParams.getDefaultProxy((HttpParams)hierarchy));
        hierarchy = new DefaultedHttpParams((HttpParams)child, (HttpParams)new DefaultedHttpParams((HttpParams)dummy, (HttpParams)daddy));
        Assert.assertNull((String)"6", (Object)ConnRouteParams.getDefaultProxy((HttpParams)hierarchy));
    }

    @Test
    public void testBadArgs() {
        try {
            ConnRouteParams.getDefaultProxy(null);
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            ConnRouteParams.getForcedRoute(null);
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            ConnRouteParams.getLocalAddress(null);
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            ConnRouteParams.setDefaultProxy(null, null);
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            ConnRouteParams.setForcedRoute(null, null);
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            ConnRouteParams.setLocalAddress(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        try {
            LOCAL1 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

