/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDigestScheme {
    @Test(expected=MalformedChallengeException.class)
    public void testDigestAuthenticationWithNoRealm() throws Exception {
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
    }

    @Test(expected=MalformedChallengeException.class)
    public void testDigestAuthenticationWithNoRealm2() throws Exception {
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest ");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
    }

    @Test
    public void testDigestAuthenticationWithDefaultCreds() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"e95a7ddf37c2eab009568b1ed134f89a", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthentication() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"e95a7ddf37c2eab009568b1ed134f89a", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationWithSHA() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", algorithm=SHA";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"8769e82e4e28ecc040b969562b9050580c6d186d", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationWithQueryStringInDigestURI() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/?param=value");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/?param=value", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"a847f58f5fef0bc087bcb9c3eb30e042", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationWithMultipleRealms() throws Exception {
        String challenge1 = "Digest realm=\"realm1\", nonce=\"abcde\"";
        String challenge2 = "Digest realm=\"realm2\", nonce=\"123546\"";
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        UsernamePasswordCredentials cred2 = new UsernamePasswordCredentials("uname2", "password2");
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge1);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"abcde", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"786f500303eac1478f3c2865e676ed68", (Object)table.get("response"));
        authChallenge = new BasicHeader("WWW-Authenticate", challenge2);
        DigestScheme authscheme2 = new DigestScheme();
        authscheme2.processChallenge((Header)authChallenge);
        authResponse = authscheme2.authenticate((Credentials)cred2, (HttpRequest)request);
        table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"uname2", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm2", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"123546", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"0283edd9ef06a38b378b3b74661391e9", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationMD5Sess() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"" + realm + "\", " + "nonce=\"" + nonce + "\", " + "opaque=\"SomeString\", " + "stale=false, " + "algorithm=MD5-sess, " + "qop=\"auth,auth-int\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(username, password);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        String response = authResponse.getValue();
        Assert.assertTrue((response.indexOf("nc=00000001") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("qop=auth") > 0 ? 1 : 0) != 0);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)username, (Object)table.get("username"));
        Assert.assertEquals((Object)realm, (Object)table.get("realm"));
        Assert.assertEquals((Object)"MD5-sess", (Object)table.get("algorithm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)nonce, (Object)table.get("nonce"));
        Assert.assertEquals((long)1L, (long)Integer.parseInt(table.get("nc"), 16));
        Assert.assertTrue((null != table.get("cnonce") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"SomeString", (Object)table.get("opaque"));
        Assert.assertEquals((Object)"auth", (Object)table.get("qop"));
        Assert.assertTrue((null != table.get("response") ? 1 : 0) != 0);
    }

    @Test
    public void testDigestAuthenticationMD5SessNoQop() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"" + realm + "\", " + "nonce=\"" + nonce + "\", " + "opaque=\"SomeString\", " + "stale=false, " + "algorithm=MD5-sess";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(username, password);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)username, (Object)table.get("username"));
        Assert.assertEquals((Object)realm, (Object)table.get("realm"));
        Assert.assertEquals((Object)"MD5-sess", (Object)table.get("algorithm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)nonce, (Object)table.get("nonce"));
        Assert.assertTrue((null == table.get("nc") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"SomeString", (Object)table.get("opaque"));
        Assert.assertTrue((null == table.get("qop") ? 1 : 0) != 0);
        Assert.assertTrue((null != table.get("response") ? 1 : 0) != 0);
    }

    @Test(expected=AuthenticationException.class)
    public void testDigestAuthenticationMD5SessUnknownQop() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"" + realm + "\", " + "nonce=\"" + nonce + "\", " + "opaque=\"SomeString\", " + "stale=false, " + "algorithm=MD5-sess, " + "qop=\"stuff\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(username, password);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        authscheme.authenticate((Credentials)cred, (HttpRequest)request);
    }

    @Test(expected=AuthenticationException.class)
    public void testDigestAuthenticationUnknownAlgo() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"" + realm + "\", " + "nonce=\"" + nonce + "\", " + "opaque=\"SomeString\", " + "stale=false, " + "algorithm=stuff, " + "qop=\"auth\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(username, password);
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        authscheme.authenticate((Credentials)cred, (HttpRequest)request);
    }

    @Test
    public void testDigestAuthenticationWithStaleNonce() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", stale=\"true\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", challenge);
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Assert.assertFalse((boolean)authscheme.isComplete());
    }

    private static Map<String, String> parseAuthResponse(Header authResponse) {
        String s = authResponse.getValue();
        if (!s.startsWith("Digest ")) {
            return null;
        }
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)s.substring(7), null);
        HashMap<String, String> map = new HashMap<String, String>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            HeaderElement element = elements[i];
            map.put(element.getName(), element.getValue());
        }
        return map;
    }

    @Test
    public void testDigestNouceCount() throws Exception {
        String challenge1 = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth";
        BasicHeader authChallenge1 = new BasicHeader("WWW-Authenticate", challenge1);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge1);
        Header authResponse1 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table1 = TestDigestScheme.parseAuthResponse(authResponse1);
        Assert.assertEquals((Object)"00000001", (Object)table1.get("nc"));
        Header authResponse2 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table2 = TestDigestScheme.parseAuthResponse(authResponse2);
        Assert.assertEquals((Object)"00000002", (Object)table2.get("nc"));
        String challenge2 = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth";
        BasicHeader authChallenge2 = new BasicHeader("WWW-Authenticate", challenge2);
        authscheme.processChallenge((Header)authChallenge2);
        Header authResponse3 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table3 = TestDigestScheme.parseAuthResponse(authResponse3);
        Assert.assertEquals((Object)"00000003", (Object)table3.get("nc"));
        String challenge3 = "Digest realm=\"realm1\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", qop=auth";
        BasicHeader authChallenge3 = new BasicHeader("WWW-Authenticate", challenge3);
        authscheme.processChallenge((Header)authChallenge3);
        Header authResponse4 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table4 = TestDigestScheme.parseAuthResponse(authResponse4);
        Assert.assertEquals((Object)"00000001", (Object)table4.get("nc"));
    }

    @Test
    public void testDigestMD5SessA1AndCnonceConsistency() throws Exception {
        String challenge1 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"";
        BasicHeader authChallenge1 = new BasicHeader("WWW-Authenticate", challenge1);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge1);
        Header authResponse1 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table1 = TestDigestScheme.parseAuthResponse(authResponse1);
        Assert.assertEquals((Object)"00000001", (Object)table1.get("nc"));
        String cnonce1 = authscheme.getCnonce();
        String sessionKey1 = authscheme.getA1();
        Header authResponse2 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table2 = TestDigestScheme.parseAuthResponse(authResponse2);
        Assert.assertEquals((Object)"00000002", (Object)table2.get("nc"));
        String cnonce2 = authscheme.getCnonce();
        String sessionKey2 = authscheme.getA1();
        Assert.assertEquals((Object)cnonce1, (Object)cnonce2);
        Assert.assertEquals((Object)sessionKey1, (Object)sessionKey2);
        String challenge2 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"";
        BasicHeader authChallenge2 = new BasicHeader("WWW-Authenticate", challenge2);
        authscheme.processChallenge((Header)authChallenge2);
        Header authResponse3 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table3 = TestDigestScheme.parseAuthResponse(authResponse3);
        Assert.assertEquals((Object)"00000003", (Object)table3.get("nc"));
        String cnonce3 = authscheme.getCnonce();
        String sessionKey3 = authscheme.getA1();
        Assert.assertEquals((Object)cnonce1, (Object)cnonce3);
        Assert.assertEquals((Object)sessionKey1, (Object)sessionKey3);
        String challenge3 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"fedcba0987654321\", charset=utf-8, realm=\"subnet.domain.com\"";
        BasicHeader authChallenge3 = new BasicHeader("WWW-Authenticate", challenge3);
        authscheme.processChallenge((Header)authChallenge3);
        Header authResponse4 = authscheme.authenticate((Credentials)cred, (HttpRequest)request);
        Map<String, String> table4 = TestDigestScheme.parseAuthResponse(authResponse4);
        Assert.assertEquals((Object)"00000001", (Object)table4.get("nc"));
        String cnonce4 = authscheme.getCnonce();
        String sessionKey4 = authscheme.getA1();
        Assert.assertFalse((boolean)cnonce1.equals(cnonce4));
        Assert.assertFalse((boolean)sessionKey1.equals(sessionKey4));
    }
}

