/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.IOException;
import java.security.Principal;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.NegotiateScheme;
import org.apache.http.impl.auth.NegotiateSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestNegotiateScheme
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    @Test
    public void testDontTryToAuthenticateEndlessly() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new PleaseNegotiateService());
        HttpHost target = new HttpHost("localhost", port);
        DefaultHttpClient client = new DefaultHttpClient();
        NegotiateSchemeFactoryWithMockGssManager nsf = new NegotiateSchemeFactoryWithMockGssManager();
        client.getAuthSchemes().register("negotiate", (AuthSchemeFactory)nsf);
        UseJaasCredentials use_jaas_creds = new UseJaasCredentials();
        client.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), (Credentials)use_jaas_creds);
        client.getParams().setParameter("http.default-host", (Object)target);
        String s = "/path";
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = client.execute((HttpUriRequest)httpget);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testNoTokenGeneratedError() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new PleaseNegotiateService());
        HttpHost target = new HttpHost("localhost", port);
        DefaultHttpClient client = new DefaultHttpClient();
        NegotiateSchemeFactoryWithMockGssManager nsf = new NegotiateSchemeFactoryWithMockGssManager();
        client.getAuthSchemes().register("negotiate", (AuthSchemeFactory)nsf);
        UseJaasCredentials use_jaas_creds = new UseJaasCredentials();
        client.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), (Credentials)use_jaas_creds);
        client.getParams().setParameter("http.default-host", (Object)target);
        String s = "/path";
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = client.execute((HttpUriRequest)httpget);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    private static class NegotiateSchemeFactoryWithMockGssManager
    extends NegotiateSchemeFactory {
        NegotiateSchemeWithMockGssManager scheme = new NegotiateSchemeWithMockGssManager();

        NegotiateSchemeFactoryWithMockGssManager() throws Exception {
        }

        public AuthScheme newInstance(HttpParams params) {
            return this.scheme;
        }
    }

    private static class UseJaasCredentials
    implements Credentials {
        private UseJaasCredentials() {
        }

        public String getPassword() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }
    }

    private static class NegotiateSchemeWithMockGssManager
    extends NegotiateScheme {
        GSSManager manager = (GSSManager)Mockito.mock(GSSManager.class);
        GSSName name = (GSSName)Mockito.mock(GSSName.class);
        GSSContext context = (GSSContext)Mockito.mock(GSSContext.class);

        NegotiateSchemeWithMockGssManager() throws Exception {
            super(null, true);
            Mockito.when((Object)this.context.initSecContext((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)"12345678".getBytes());
            Mockito.when((Object)this.manager.createName((String)Matchers.any(String.class), (Oid)Matchers.any(Oid.class))).thenReturn((Object)this.name);
            Mockito.when((Object)this.manager.createContext((GSSName)Matchers.any(GSSName.class), (Oid)Matchers.any(Oid.class), (GSSCredential)Matchers.any(GSSCredential.class), Matchers.anyInt())).thenReturn((Object)this.context);
        }

        protected GSSManager getManager() {
            return this.manager;
        }
    }

    private static class PleaseNegotiateService
    implements HttpRequestHandler {
        private PleaseNegotiateService() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(401);
            response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Negotiate blablabla"));
            response.addHeader((Header)new BasicHeader("Connection", "Keep-Alive"));
            response.setEntity((HttpEntity)new StringEntity("auth required "));
        }
    }
}

