/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestContentCodings
extends ServerTestBase {
    @Test
    public void testResponseWithNoContent() throws Exception {
        this.localServer.register("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(204);
            }
        });
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)request);
        Assert.assertEquals((long)204L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNull((Object)response.getEntity());
        client.getConnectionManager().shutdown();
    }

    @Test
    public void testDeflateSupportForServerReturningRfc1950Stream() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", false));
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)request);
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        client.getConnectionManager().shutdown();
    }

    @Test
    public void testDeflateSupportForServerReturningRfc1951Stream() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", true));
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)request);
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        client.getConnectionManager().shutdown();
    }

    @Test
    public void testGzipSupport() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)request);
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        client.getConnectionManager().shutdown();
    }

    @Test
    public void testThreadSafetyOfContentCodings() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        int clients = 100;
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(schemeRegistry);
        cm.setMaxTotal(clients);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
        ExecutorService executor = Executors.newFixedThreadPool(clients);
        CountDownLatch startGate = new CountDownLatch(1);
        CountDownLatch endGate = new CountDownLatch(clients);
        ArrayList<WorkerTask> workers = new ArrayList<WorkerTask>();
        for (int i = 0; i < clients; ++i) {
            workers.add(new WorkerTask((HttpClient)httpClient, i % 2 == 0, startGate, endGate));
        }
        for (WorkerTask workerTask : workers) {
            executor.execute(workerTask);
        }
        startGate.countDown();
        endGate.await();
        for (WorkerTask workerTask : workers) {
            if (workerTask.isFailed()) {
                Assert.fail((String)"A worker failed");
            }
            Assert.assertEquals((Object)"Hello, this is some plain text coming back.", (Object)workerTask.getText());
        }
    }

    @Test
    public void testCanBeDisabledAtRequestTime() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        final boolean[] sawAcceptEncodingHeader = new boolean[]{true};
        this.localServer.register("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setEntity((HttpEntity)new StringEntity("Hello, this is some plain text coming back."));
                response.addHeader("Content-Type", "text/plain");
                Header[] acceptEncodings = request.getHeaders("Accept-Encoding");
                sawAcceptEncodingHeader[0] = acceptEncodings.length > 0;
            }
        });
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        client.removeRequestInterceptorByClass(RequestAcceptEncoding.class);
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)request);
        Assert.assertFalse((String)"The Accept-Encoding header was not there", (boolean)sawAcceptEncodingHeader[0]);
        Assert.assertEquals((String)"The entity isn't treated as gzip or zip content", (Object)"Hello, this is some plain text coming back.", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        client.getConnectionManager().shutdown();
    }

    @Test
    public void testHttpEntityWriteToForGzip() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)out);
        Assert.assertEquals((Object)"Hello, this is some plain text coming back.", (Object)out.toString("utf-8"));
        client.getConnectionManager().shutdown();
    }

    @Test
    public void testHttpEntityWriteToForDeflate() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", true));
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)out);
        Assert.assertEquals((Object)"Hello, this is some plain text coming back.", (Object)out.toString("utf-8"));
        client.getConnectionManager().shutdown();
    }

    @Test
    public void gzipResponsesWorkWithBasicResponseHandler() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createGzipEncodingRequestHandler("Hello, this is some plain text coming back."));
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        String response = (String)client.execute(this.getServerHttp(), (HttpRequest)request, (ResponseHandler)new BasicResponseHandler());
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)response);
        client.getConnectionManager().shutdown();
    }

    @Test
    public void deflateResponsesWorkWithBasicResponseHandler() throws Exception {
        String entityText = "Hello, this is some plain text coming back.";
        this.localServer.register("*", this.createDeflateEncodingRequestHandler("Hello, this is some plain text coming back.", false));
        DefaultHttpClient client = this.createHttpClient();
        HttpGet request = new HttpGet("/some-resource");
        String response = (String)client.execute(this.getServerHttp(), (HttpRequest)request, (ResponseHandler)new BasicResponseHandler());
        Assert.assertEquals((String)"The entity text is correctly transported", (Object)"Hello, this is some plain text coming back.", (Object)response);
        client.getConnectionManager().shutdown();
    }

    private HttpRequestHandler createDeflateEncodingRequestHandler(final String entityText, final boolean rfc1951) {
        return new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header[] acceptEncodings;
                response.setEntity((HttpEntity)new StringEntity(entityText));
                response.addHeader("Content-Type", "text/plain");
                for (Header header : acceptEncodings = request.getHeaders("Accept-Encoding")) {
                    for (HeaderElement element : header.getElements()) {
                        if (!"deflate".equalsIgnoreCase(element.getName())) continue;
                        response.addHeader("Content-Encoding", "deflate");
                        byte[] uncompressed = entityText.getBytes("utf-8");
                        Deflater compressor = new Deflater(-1, rfc1951);
                        compressor.setInput(uncompressed);
                        compressor.finish();
                        byte[] output = new byte[100];
                        int compressedLength = compressor.deflate(output);
                        byte[] compressed = new byte[compressedLength];
                        System.arraycopy(output, 0, compressed, 0, compressedLength);
                        response.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(compressed), (long)compressedLength));
                        return;
                    }
                }
            }
        };
    }

    private HttpRequestHandler createGzipEncodingRequestHandler(final String entityText) {
        return new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header[] acceptEncodings;
                response.setEntity((HttpEntity)new StringEntity(entityText));
                response.addHeader("Content-Type", "text/plain");
                for (Header header : acceptEncodings = request.getHeaders("Accept-Encoding")) {
                    for (HeaderElement element : header.getElements()) {
                        int n;
                        if (!"gzip".equalsIgnoreCase(element.getName())) continue;
                        response.addHeader("Content-Encoding", "gzip");
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        GZIPOutputStream out = new GZIPOutputStream(bytes);
                        ByteArrayInputStream uncompressed = new ByteArrayInputStream(entityText.getBytes("utf-8"));
                        byte[] buf = new byte[60];
                        while ((n = uncompressed.read(buf)) != -1) {
                            ((OutputStream)out).write(buf, 0, n);
                        }
                        ((OutputStream)out).close();
                        byte[] arr = bytes.toByteArray();
                        response.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(arr), (long)arr.length));
                        return;
                    }
                }
            }
        };
    }

    private DefaultHttpClient createHttpClient() {
        return new ContentEncodingHttpClient();
    }

    class WorkerTask
    implements Runnable {
        private final HttpClient client;
        private final HttpGet request;
        private boolean failed = false;
        private final CountDownLatch startGate;
        private final CountDownLatch endGate;
        private String text;

        WorkerTask(HttpClient client, boolean identity, CountDownLatch startGate, CountDownLatch endGate) {
            this.client = client;
            this.request = new HttpGet("/some-resource");
            if (identity) {
                this.request.addHeader("Accept-Encoding", "identity");
            }
            this.startGate = startGate;
            this.endGate = endGate;
        }

        public String getText() {
            return this.text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.startGate.await();
                try {
                    HttpResponse response = this.client.execute(TestContentCodings.this.getServerHttp(), (HttpRequest)this.request);
                    this.text = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (Exception e) {
                    this.failed = true;
                }
                finally {
                    this.endGate.countDown();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        boolean isFailed() {
            return this.failed;
        }
    }
}

