/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.ClientConnAdapterMockup;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.message.BasicHeader;
import org.apache.http.mockup.SocketFactoryMockup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultClientRequestDirector
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    @Test
    public void testAbortInAllocate() throws Exception {
        CountDownLatch connLatch = new CountDownLatch(1);
        CountDownLatch awaitLatch = new CountDownLatch(1);
        ConMan conMan = new ConMan(connLatch, awaitLatch);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("http://www.example.com/a");
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    client.execute((HttpUriRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((String)"should have tried to get a connection", (boolean)connLatch.await(1L, TimeUnit.SECONDS));
        httpget.abort();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
        Assert.assertTrue((String)("cause should be InterruptedException, was: " + ((Throwable)throwableRef.get()).getCause()), (boolean)(((Throwable)throwableRef.get()).getCause() instanceof InterruptedException));
    }

    @Test
    public void testAbortAfterAllocateBeforeRequest() throws Exception {
        this.localServer.register("*", new BasicService());
        CountDownLatch releaseLatch = new CountDownLatch(1);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        SingleClientConnManager conMan = new SingleClientConnManager(registry);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final CustomGet httpget = new CustomGet("a", releaseLatch);
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    client.execute(TestDefaultClientRequestDirector.this.getServerHttp(), (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Thread.sleep(100L);
        httpget.abort();
        releaseLatch.countDown();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testAbortBeforeExecute() throws Exception {
        this.localServer.register("*", new BasicService());
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        SingleClientConnManager conMan = new SingleClientConnManager(registry);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("a");
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        if (!startLatch.await(1L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("Took too long to start!");
                        }
                    }
                    catch (InterruptedException interrupted) {
                        throw new RuntimeException("Never started!", interrupted);
                    }
                    client.execute(TestDefaultClientRequestDirector.this.getServerHttp(), (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        httpget.abort();
        startLatch.countDown();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
    }

    @Test
    public void testAbortAfterRedirectedRoute() throws Exception {
        final int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new BasicRedirectService(port));
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        CountDownLatch connLatch = new CountDownLatch(1);
        CountDownLatch awaitLatch = new CountDownLatch(1);
        ConnMan4 conMan = new ConnMan4(registry, connLatch, awaitLatch);
        AtomicReference throwableRef = new AtomicReference();
        CountDownLatch getLatch = new CountDownLatch(1);
        final DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        final HttpGet httpget = new HttpGet("a");
        new Thread(new Runnable((HttpContext)context, throwableRef, getLatch){
            final /* synthetic */ HttpContext val$context;
            final /* synthetic */ AtomicReference val$throwableRef;
            final /* synthetic */ CountDownLatch val$getLatch;
            {
                this.val$context = httpContext;
                this.val$throwableRef = atomicReference;
                this.val$getLatch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    HttpHost host = new HttpHost("127.0.0.1", port);
                    client.execute(host, (HttpRequest)httpget, this.val$context);
                }
                catch (Throwable t) {
                    this.val$throwableRef.set(t);
                }
                finally {
                    this.val$getLatch.countDown();
                }
            }
        }).start();
        Assert.assertTrue((String)"should have tried to get a connection", (boolean)connLatch.await(1L, TimeUnit.SECONDS));
        httpget.abort();
        Assert.assertTrue((String)"should have finished get request", (boolean)getLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("should be instanceof IOException, was: " + throwableRef.get()), (boolean)(throwableRef.get() instanceof IOException));
        Assert.assertTrue((String)("cause should be InterruptedException, was: " + ((Throwable)throwableRef.get()).getCause()), (boolean)(((Throwable)throwableRef.get()).getCause() instanceof InterruptedException));
    }

    @Test
    public void testSocketConnectFailureReleasesConnection() throws Exception {
        ConnMan2 conMan = new ConnMan2();
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        BasicHttpContext context = new BasicHttpContext();
        HttpGet httpget = new HttpGet("http://www.example.com/a");
        try {
            client.execute((HttpUriRequest)httpget, (HttpContext)context);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertNotNull((Object)conMan.allocatedConnection);
        Assert.assertSame((Object)conMan.allocatedConnection, (Object)conMan.releasedConnection);
    }

    @Test
    public void testRequestFailureReleasesConnection() throws Exception {
        this.localServer.register("*", new ThrowingService());
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        ConnMan3 conMan = new ConnMan3(registry);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)conMan, (HttpParams)new BasicHttpParams());
        HttpGet httpget = new HttpGet("/a");
        try {
            client.execute(this.getServerHttp(), (HttpRequest)httpget);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertNotNull((Object)conMan.allocatedConnection);
        Assert.assertSame((Object)conMan.allocatedConnection, (Object)conMan.releasedConnection);
    }

    @Test
    public void testDefaultHostAtClientLevel() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        HttpHost target = new HttpHost("localhost", port);
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.default-host", (Object)target);
        String s = "/path";
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = client.execute((HttpUriRequest)httpget);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testDefaultHostHeader() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        String hostname = this.localServer.getServiceAddress().getHostName();
        this.localServer.register("*", new SimpleService());
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = reqWrapper.getHeaders("host");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)(hostname + ":" + port), (Object)headers[0].getValue());
    }

    @Test
    public void testVirtualHostHeader() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        DefaultHttpClient client = new DefaultHttpClient();
        String virtHost = "virtual";
        httpget.getParams().setParameter("http.virtual-host", (Object)new HttpHost(virtHost, port));
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = reqWrapper.getHeaders("host");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)(virtHost + ":" + port), (Object)headers[0].getValue());
    }

    @Test
    public void testVirtualHostPortHeader() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        DefaultHttpClient client = new DefaultHttpClient();
        String virtHost = "virtual";
        int virtPort = 9876;
        httpget.getParams().setParameter("http.virtual-host", (Object)new HttpHost(virtHost, virtPort));
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = reqWrapper.getHeaders("host");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)(virtHost + ":" + virtPort), (Object)headers[0].getValue());
    }

    @Test
    public void testDefaultHostAtRequestLevel() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        HttpHost target1 = new HttpHost("whatever", 80);
        HttpHost target2 = new HttpHost("localhost", port);
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.default-host", (Object)target1);
        String s = "/path";
        HttpGet httpget = new HttpGet(s);
        httpget.getParams().setParameter("http.default-host", (Object)target2);
        HttpResponse response = client.execute((HttpUriRequest)httpget);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testAutoGeneratedHeaders() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        FaultyHttpClient client = new FaultyHttpClient();
        client.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader("my-header", "stuff");
            }
        });
        client.setHttpRequestRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return true;
            }
        });
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)(reqWrapper instanceof RequestWrapper));
        Header[] myheaders = reqWrapper.getHeaders("my-header");
        Assert.assertNotNull((Object)myheaders);
        Assert.assertEquals((long)1L, (long)myheaders.length);
    }

    @Test(expected=ClientProtocolException.class)
    public void testNonRepeatableEntity() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        String failureMsg = "a message showing that this failed";
        FaultyHttpClient client = new FaultyHttpClient(failureMsg);
        client.setHttpRequestRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return true;
            }
        });
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpPost httppost = new HttpPost(s);
        httppost.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}), -1L));
        try {
            client.execute(this.getServerHttp(), (HttpRequest)httppost, (HttpContext)context);
        }
        catch (ClientProtocolException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof NonRepeatableRequestException));
            NonRepeatableRequestException nonRepeat = (NonRepeatableRequestException)ex.getCause();
            Assert.assertTrue((boolean)(nonRepeat.getCause() instanceof IOException));
            Assert.assertEquals((Object)failureMsg, (Object)nonRepeat.getCause().getMessage());
            throw ex;
        }
    }

    private static class FaultyHttpClient
    extends DefaultHttpClient {
        private final String failureMsg;

        public FaultyHttpClient() {
            this("Oppsie");
        }

        public FaultyHttpClient(String failureMsg) {
            this.failureMsg = failureMsg;
        }

        protected HttpRequestExecutor createRequestExecutor() {
            return new FaultyHttpRequestExecutor(this.failureMsg);
        }
    }

    private static class FaultyHttpRequestExecutor
    extends HttpRequestExecutor {
        private static final String MARKER = "marker";
        private final String failureMsg;

        public FaultyHttpRequestExecutor(String failureMsg) {
            this.failureMsg = failureMsg;
        }

        public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
            HttpResponse response = super.execute(request, conn, context);
            Object marker = context.getAttribute(MARKER);
            if (marker == null) {
                context.setAttribute(MARKER, (Object)Boolean.TRUE);
                throw new IOException(this.failureMsg);
            }
            return response;
        }
    }

    private static class SimpleService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            StringEntity entity = new StringEntity("Whatever");
            response.setEntity((HttpEntity)entity);
        }
    }

    private static class CustomGet
    extends HttpGet {
        private final CountDownLatch releaseTriggerLatch;

        public CustomGet(String uri, CountDownLatch releaseTriggerLatch) {
            super(uri);
            this.releaseTriggerLatch = releaseTriggerLatch;
        }

        public void setReleaseTrigger(ConnectionReleaseTrigger releaseTrigger) throws IOException {
            try {
                if (!this.releaseTriggerLatch.await(1L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Waited too long...");
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            super.setReleaseTrigger(releaseTrigger);
        }
    }

    static class ConMan
    implements ClientConnectionManager {
        private final CountDownLatch connLatch;
        private final CountDownLatch awaitLatch;

        public ConMan(CountDownLatch connLatch, CountDownLatch awaitLatch) {
            this.connLatch = connLatch;
            this.awaitLatch = awaitLatch;
        }

        public void closeIdleConnections(long idletime, TimeUnit tunit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void closeExpiredConnections() {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ManagedClientConnection getConnection(HttpRoute route) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ManagedClientConnection getConnection(HttpRoute route, long timeout, TimeUnit tunit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
            final Thread currentThread = Thread.currentThread();
            return new ClientConnectionRequest(){

                public void abortRequest() {
                    currentThread.interrupt();
                }

                public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                    ConMan.this.connLatch.countDown();
                    if (timeout == 0L) {
                        timeout = Integer.MAX_VALUE;
                    }
                    if (!ConMan.this.awaitLatch.await(timeout, tunit)) {
                        throw new ConnectionPoolTimeoutException();
                    }
                    return new ClientConnAdapterMockup(ConMan.this);
                }
            };
        }

        public HttpParams getParams() {
            throw new UnsupportedOperationException("just a mockup");
        }

        public SchemeRegistry getSchemeRegistry() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)new SocketFactoryMockup(null)));
            return registry;
        }

        public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void shutdown() {
            throw new UnsupportedOperationException("just a mockup");
        }
    }

    static class ConnMan2
    implements ClientConnectionManager {
        private ManagedClientConnection allocatedConnection;
        private ManagedClientConnection releasedConnection;

        public void closeIdleConnections(long idletime, TimeUnit tunit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public void closeExpiredConnections() {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ManagedClientConnection getConnection(HttpRoute route) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ManagedClientConnection getConnection(HttpRoute route, long timeout, TimeUnit tunit) {
            throw new UnsupportedOperationException("just a mockup");
        }

        public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
            return new ClientConnectionRequest(){

                public void abortRequest() {
                    throw new UnsupportedOperationException("just a mockup");
                }

                public ManagedClientConnection getConnection(long timeout, TimeUnit unit) throws InterruptedException, ConnectionPoolTimeoutException {
                    ConnMan2.this.allocatedConnection = (ManagedClientConnection)new ClientConnAdapterMockup(ConnMan2.this){

                        public void open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
                            throw new ConnectException();
                        }
                    };
                    return ConnMan2.this.allocatedConnection;
                }
            };
        }

        public HttpParams getParams() {
            throw new UnsupportedOperationException("just a mockup");
        }

        public SchemeRegistry getSchemeRegistry() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)new SocketFactoryMockup(null)));
            return registry;
        }

        public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
            this.releasedConnection = conn;
        }

        public void shutdown() {
            throw new UnsupportedOperationException("just a mockup");
        }
    }

    private static class ConnMan3
    extends SingleClientConnManager {
        private ManagedClientConnection allocatedConnection;
        private ManagedClientConnection releasedConnection;

        public ConnMan3(SchemeRegistry schreg) {
            super(schreg);
        }

        public ManagedClientConnection getConnection(HttpRoute route, Object state) {
            this.allocatedConnection = super.getConnection(route, state);
            return this.allocatedConnection;
        }

        public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
            this.releasedConnection = conn;
            super.releaseConnection(conn, validDuration, timeUnit);
        }
    }

    private static class ConnMan4
    extends ThreadSafeClientConnManager {
        private final CountDownLatch connLatch;
        private final CountDownLatch awaitLatch;

        public ConnMan4(SchemeRegistry schreg, CountDownLatch connLatch, CountDownLatch awaitLatch) {
            super(schreg);
            this.connLatch = connLatch;
            this.awaitLatch = awaitLatch;
        }

        public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
            if (route.getTargetHost().getHostName().equals("localhost")) {
                final Thread currentThread = Thread.currentThread();
                return new ClientConnectionRequest(){

                    public void abortRequest() {
                        currentThread.interrupt();
                    }

                    public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                        ConnMan4.this.connLatch.countDown();
                        if (timeout == 0L) {
                            timeout = Integer.MAX_VALUE;
                        }
                        if (!ConnMan4.this.awaitLatch.await(timeout, tunit)) {
                            throw new ConnectionPoolTimeoutException();
                        }
                        return new ClientConnAdapterMockup((ClientConnectionManager)ConnMan4.this);
                    }
                };
            }
            return super.requestConnection(route, state);
        }
    }

    private static class BasicRedirectService
    implements HttpRequestHandler {
        private int statuscode = 303;
        private int port;

        public BasicRedirectService(int port) {
            this.port = port;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            response.setStatusLine(ver, this.statuscode);
            response.addHeader((Header)new BasicHeader("Location", "http://localhost:" + this.port + "/newlocation/"));
            response.addHeader((Header)new BasicHeader("Connection", "close"));
        }
    }

    private static class BasicService
    implements HttpRequestHandler {
        private BasicService() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            response.setEntity((HttpEntity)new StringEntity("Hello World"));
        }
    }

    private static class ThrowingService
    implements HttpRequestHandler {
        private ThrowingService() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            throw new IOException();
        }
    }
}

