/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestStatefulConnManagement
extends ServerTestBase {
    @Test
    public void testStatefulConnections() throws Exception {
        BasicHttpContext context;
        int i;
        int workerCount = 5;
        int requestCount = 5;
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        HttpHost target = new HttpHost("localhost", port);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10);
        ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(this.supportedSchemes);
        mgr.setMaxTotal(workerCount);
        mgr.setDefaultMaxPerRoute(workerCount);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
        HttpContext[] contexts = new HttpContext[workerCount];
        HttpWorker[] workers = new HttpWorker[workerCount];
        for (i = 0; i < contexts.length; ++i) {
            context = new BasicHttpContext();
            context.setAttribute("user", (Object)i);
            contexts[i] = context;
            workers[i] = new HttpWorker((HttpContext)context, requestCount, target, (HttpClient)client);
        }
        client.setUserTokenHandler(new UserTokenHandler(){

            public Object getUserToken(HttpContext context) {
                Integer id = (Integer)context.getAttribute("user");
                return id;
            }
        });
        for (i = 0; i < workers.length; ++i) {
            workers[i].start();
        }
        for (i = 0; i < workers.length; ++i) {
            workers[i].join(10000L);
        }
        for (i = 0; i < workers.length; ++i) {
            Exception ex = workers[i].getException();
            if (ex != null) {
                throw ex;
            }
            Assert.assertEquals((long)requestCount, (long)workers[i].getCount());
        }
        for (i = 0; i < contexts.length; ++i) {
            context = contexts[i];
            Integer id = (Integer)context.getAttribute("user");
            for (int r = 0; r < requestCount; ++r) {
                Integer state = (Integer)context.getAttribute("r" + r);
                Assert.assertNotNull((Object)state);
                Assert.assertEquals((Object)id, (Object)state);
            }
        }
    }

    @Test
    public void testRouteSpecificPoolRecylcing() throws Exception {
        int maxConn = 2;
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        ThreadSafeClientConnManager connMngr = new ThreadSafeClientConnManager(this.supportedSchemes);
        connMngr.setMaxTotal(maxConn);
        connMngr.setDefaultMaxPerRoute(maxConn);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connMngr);
        client.setUserTokenHandler(new UserTokenHandler(){

            public Object getUserToken(HttpContext context) {
                return context.getAttribute("user");
            }
        });
        BasicHttpContext context1 = new BasicHttpContext();
        context1.setAttribute("user", (Object)"stuff");
        HttpResponse response1 = client.execute(new HttpHost("localhost", port), (HttpRequest)new HttpGet("/"), (HttpContext)context1);
        EntityUtils.consume((HttpEntity)response1.getEntity());
        Thread.sleep(100L);
        BasicHttpContext context2 = new BasicHttpContext();
        HttpResponse response2 = client.execute(new HttpHost("127.0.0.1", port), (HttpRequest)new HttpGet("/"), (HttpContext)context2);
        EntityUtils.consume((HttpEntity)response2.getEntity());
        Thread.sleep(100L);
        BasicHttpContext context3 = new BasicHttpContext();
        HttpResponse response3 = client.execute(new HttpHost("localhost", port), (HttpRequest)new HttpGet("/"), (HttpContext)context3);
        EntityUtils.consume((HttpEntity)response3.getEntity());
    }

    static class HttpWorker
    extends Thread {
        private final HttpContext context;
        private final int requestCount;
        private final HttpHost target;
        private final HttpClient httpclient;
        private volatile Exception exception;
        private volatile int count;

        public HttpWorker(HttpContext context, int requestCount, HttpHost target, HttpClient httpclient) {
            this.context = context;
            this.requestCount = requestCount;
            this.target = target;
            this.httpclient = httpclient;
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        public Exception getException() {
            return this.exception;
        }

        public void run() {
            try {
                for (int r = 0; r < this.requestCount; ++r) {
                    HttpGet httpget = new HttpGet("/");
                    HttpResponse response = this.httpclient.execute(this.target, (HttpRequest)httpget, this.context);
                    ++this.count;
                    ManagedClientConnection conn = (ManagedClientConnection)this.context.getAttribute("http.connection");
                    this.context.setAttribute("r" + r, conn.getState());
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }
    }

    private static class SimpleService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            StringEntity entity = new StringEntity("Whatever");
            response.setEntity((HttpEntity)entity);
        }
    }
}

