/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.mockup.ProxySelectorMockup;
import org.junit.Assert;
import org.junit.Test;

public class TestProxySelRoutePlanner {
    public SchemeRegistry createSchemeRegistry() {
        SchemeRegistry schreg = new SchemeRegistry();
        schreg.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        return schreg;
    }

    @Test
    public void testDirect() throws Exception {
        ProxySelectorRoutePlanner hrp = new ProxySelectorRoutePlanner(this.createSchemeRegistry(), (ProxySelector)new ProxySelectorMockup(null));
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpRoute route = hrp.determineRoute(target, (HttpRequest)request, null);
        Assert.assertEquals((String)"wrong target", (Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((String)"not direct", (long)1L, (long)route.getHopCount());
    }

    @Test
    public void testProxy() throws Exception {
        InetAddress ia = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        InetSocketAddress isa1 = new InetSocketAddress(ia, 11111);
        InetSocketAddress isa2 = new InetSocketAddress(ia, 22222);
        ArrayList<Proxy> proxies = new ArrayList<Proxy>(2);
        proxies.add(new Proxy(Proxy.Type.HTTP, isa1));
        proxies.add(new Proxy(Proxy.Type.HTTP, isa2));
        ProxySelectorRoutePlanner hrp = new ProxySelectorRoutePlanner(this.createSchemeRegistry(), (ProxySelector)new ProxySelectorMockup(proxies));
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpRoute route = hrp.determineRoute(target, (HttpRequest)request, null);
        Assert.assertEquals((String)"wrong target", (Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((String)"not via proxy", (long)2L, (long)route.getHopCount());
        Assert.assertEquals((String)"wrong proxy", (long)isa1.getPort(), (long)route.getProxyHost().getPort());
    }
}

