/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.AbstractClientConnAdapter;
import org.apache.http.impl.conn.Helper;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestSCMWithServer
extends ServerTestBase {
    public SingleClientConnManager createSCCM(SchemeRegistry schreg) {
        if (schreg == null) {
            schreg = this.supportedSchemes;
        }
        return new SingleClientConnManager(schreg);
    }

    @Test
    public void testOpenAfterAbort() throws Exception {
        SingleClientConnManager mgr = this.createSCCM(null);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = mgr.getConnection(route, null);
        Assert.assertTrue((boolean)(conn instanceof AbstractClientConnAdapter));
        ((AbstractClientConnAdapter)conn).abortConnection();
        conn = mgr.getConnection(route, null);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        mgr.releaseConnection(conn, -1L, null);
        mgr.shutdown();
    }

    @Test
    public void testReleaseConnectionWithTimeLimits() throws Exception {
        SingleClientConnManager mgr = this.createSCCM(null);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        int rsplen = 8;
        String uri = "/random/8";
        BasicHttpRequest request = new BasicHttpRequest("GET", "/random/8", (ProtocolVersion)HttpVersion.HTTP_1_1);
        ManagedClientConnection conn = mgr.getConnection(route, null);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        HttpResponse response = Helper.execute((HttpRequest)request, (HttpClientConnection)conn, target, this.httpExecutor, (HttpProcessor)this.httpProcessor, this.defaultParams, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in first response", (long)200L, (long)response.getStatusLine().getStatusCode());
        byte[] data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of first response entity", (long)8L, (long)data.length);
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        conn = mgr.getConnection(route, null);
        Assert.assertFalse((String)"connection should have been closed", (boolean)conn.isOpen());
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in second response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of second response entity", (long)8L, (long)data.length);
        conn.markReusable();
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        conn = mgr.getConnection(route, null);
        Assert.assertTrue((String)"connection should have been open", (boolean)conn.isOpen());
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of third response entity", (long)8L, (long)data.length);
        conn.markReusable();
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        Thread.sleep(150L);
        conn = mgr.getConnection(route, null);
        Assert.assertTrue((String)"connection should have been closed", (!conn.isOpen() ? 1 : 0) != 0);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        this.httpContext.setAttribute("http.connection", (Object)conn);
        response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in third response", (long)200L, (long)response.getStatusLine().getStatusCode());
        data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        Assert.assertEquals((String)"wrong length of fourth response entity", (long)8L, (long)data.length);
        mgr.shutdown();
    }

    @Test
    public void testCloseExpiredConnections() throws Exception {
        SingleClientConnManager mgr = this.createSCCM(null);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = mgr.getConnection(route, null);
        conn.open(route, (HttpContext)this.httpContext, this.defaultParams);
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        mgr.closeExpiredConnections();
        conn = mgr.getConnection(route, null);
        Assert.assertTrue((boolean)conn.isOpen());
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        Thread.sleep(150L);
        mgr.closeExpiredConnections();
        conn = mgr.getConnection(route, null);
        Assert.assertFalse((boolean)conn.isOpen());
        mgr.shutdown();
    }

    @Test(expected=IllegalStateException.class)
    public void testAlreadyLeased() throws Exception {
        SingleClientConnManager mgr = this.createSCCM(null);
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = mgr.getConnection(route, null);
        mgr.releaseConnection(conn, 100L, TimeUnit.MILLISECONDS);
        mgr.getConnection(route, null);
        mgr.getConnection(route, null);
    }
}

