/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.localserver.ServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class TestConnPoolByRoute
extends ServerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatelessConnections() throws Exception {
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(this.supportedSchemes);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(3);
        ConnPoolByRoute connPool = new ConnPoolByRoute((ClientConnectionOperator)operator, (ConnPerRoute)connPerRoute, 20);
        try {
            PoolEntryRequest r1 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e1 = r1.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e1);
            PoolEntryRequest r2 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e2 = r2.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e2);
            PoolEntryRequest r3 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e3 = r3.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e3);
            PoolEntryRequest r4 = connPool.requestPoolEntry(route, null);
            try {
                r4.getPoolEntry(250L, TimeUnit.MICROSECONDS);
                Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
            }
            catch (ConnectionPoolTimeoutException expected) {
                // empty catch block
            }
            connPool.freeEntry(e3, true, -1L, null);
            PoolEntryRequest r5 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e5 = r5.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e5);
        }
        finally {
            connPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatefullConnections() throws Exception {
        HttpHost target = this.getServerHttp();
        HttpRoute route = new HttpRoute(target, null, false);
        DefaultClientConnectionOperator operator = new DefaultClientConnectionOperator(this.supportedSchemes);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(3);
        ConnPoolByRoute connPool = new ConnPoolByRoute((ClientConnectionOperator)operator, (ConnPerRoute)connPerRoute, 20);
        try {
            PoolEntryRequest r1 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e1 = r1.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r2 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e2 = r2.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r3 = connPool.requestPoolEntry(route, null);
            BasicPoolEntry e3 = r3.getPoolEntry(10L, TimeUnit.SECONDS);
            e1.setState((Object)1);
            e2.setState((Object)2);
            e3.setState((Object)3);
            connPool.freeEntry(e1, true, -1L, null);
            connPool.freeEntry(e2, true, -1L, null);
            connPool.freeEntry(e3, true, -1L, null);
            PoolEntryRequest r4 = connPool.requestPoolEntry(route, (Object)2);
            BasicPoolEntry e4 = r4.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r5 = connPool.requestPoolEntry(route, (Object)3);
            BasicPoolEntry e5 = r5.getPoolEntry(10L, TimeUnit.SECONDS);
            PoolEntryRequest r6 = connPool.requestPoolEntry(route, (Object)1);
            BasicPoolEntry e6 = r6.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)e4.getState());
            Assert.assertNotNull((Object)e5.getState());
            Assert.assertNotNull((Object)e6.getState());
            Assert.assertTrue((e4 == e2 ? 1 : 0) != 0);
            Assert.assertTrue((e5 == e3 ? 1 : 0) != 0);
            Assert.assertTrue((e6 == e1 ? 1 : 0) != 0);
            connPool.freeEntry(e4, true, -1L, null);
            connPool.freeEntry(e5, true, -1L, null);
            connPool.freeEntry(e6, true, -1L, null);
            PoolEntryRequest r7 = connPool.requestPoolEntry(route, (Object)4);
            BasicPoolEntry e7 = r7.getPoolEntry(10L, TimeUnit.SECONDS);
            Assert.assertFalse((boolean)e7.getConnection().isOpen());
            Assert.assertNull((Object)e7.getState());
        }
        finally {
            connPool.shutdown();
        }
    }
}

