/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.Nodelet;
import com.ibatis.common.xml.NodeletException;
import com.ibatis.common.xml.NodeletParser;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;
import com.ibatis.sqlmap.engine.builder.xml.BaseParser;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapClasspathEntityResolver;
import com.ibatis.sqlmap.engine.builder.xml.SqlStatementParser;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMap;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.Discriminator;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.mapping.statement.DeleteStatement;
import com.ibatis.sqlmap.engine.mapping.statement.GeneralStatement;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.ProcedureStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectStatement;
import com.ibatis.sqlmap.engine.mapping.statement.UpdateStatement;
import com.ibatis.sqlmap.engine.type.CustomTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.dom.Node;

public class SqlMapParser
extends BaseParser {
    private static final Log log = LogFactory.getLog(class$com$ibatis$sqlmap$engine$builder$xml$SqlMapParser == null ? (class$com$ibatis$sqlmap$engine$builder$xml$SqlMapParser = SqlMapParser.class$("com.ibatis.sqlmap.engine.builder.xml.SqlMapParser")) : class$com$ibatis$sqlmap$engine$builder$xml$SqlMapParser);
    protected final NodeletParser parser = new NodeletParser();
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$builder$xml$SqlMapParser;

    public SqlMapParser(BaseParser.Variables vars) {
        super(vars);
        this.parser.setValidation(true);
        this.parser.setEntityResolver(new SqlMapClasspathEntityResolver());
        this.addSqlMapNodelets();
        this.addSqlNodelets();
        this.addTypeAliasNodelets();
        this.addCacheModelNodelets();
        this.addParameterMapNodelets();
        this.addResultMapNodelets();
        this.addStatementNodelets();
    }

    public void parse(Reader reader) throws NodeletException {
        this.parser.parse(reader);
    }

    public void parse(InputStream inputStream) throws NodeletException {
        this.parser.parse(inputStream);
    }

    private void addSqlMapNodelets() {
        this.parser.addNodelet("/sqlMap", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                SqlMapParser.this.vars.currentNamespace = attributes.getProperty("namespace");
            }
        });
        this.parser.addNodelet("/sqlMap/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                Iterator names = SqlMapParser.this.vars.delegate.getResultMapNames();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    ResultMap rm = SqlMapParser.this.vars.delegate.getResultMap(name);
                    Discriminator disc = rm.getDiscriminator();
                    if (disc == null) continue;
                    disc.bindSubMaps();
                }
            }
        });
    }

    private void addSqlNodelets() {
        this.parser.addNodelet("/sqlMap/sql", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String id = attributes.getProperty("id");
                if (SqlMapParser.this.vars.useStatementNamespaces) {
                    id = SqlMapParser.this.applyNamespace(id);
                }
                if (SqlMapParser.this.vars.sqlIncludes.containsKey(id)) {
                    log.warn("Duplicate <sql>-include '" + id + "' found.");
                } else {
                    SqlMapParser.this.vars.sqlIncludes.put(id, node);
                }
            }
        });
    }

    private void addTypeAliasNodelets() {
        this.parser.addNodelet("/sqlMap/typeAlias", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties prop = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String alias = prop.getProperty("alias");
                String type = prop.getProperty("type");
                SqlMapParser.this.vars.typeHandlerFactory.putTypeAlias(alias, type);
            }
        });
    }

    private void addCacheModelNodelets() {
        this.parser.addNodelet("/sqlMap/cacheModel", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentCacheModel = new CacheModel();
                SqlMapParser.this.vars.currentProperties = new Properties();
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.errorCtx.setActivity("building a cache model");
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String id = SqlMapParser.this.applyNamespace(attributes.getProperty("id"));
                String type = attributes.getProperty("type");
                type = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(type);
                String readOnly = attributes.getProperty("readOnly");
                if (readOnly != null && readOnly.length() > 0) {
                    SqlMapParser.this.vars.currentCacheModel.setReadOnly("true".equals(readOnly));
                } else {
                    SqlMapParser.this.vars.currentCacheModel.setReadOnly(true);
                }
                String serialize = attributes.getProperty("serialize");
                if (serialize != null && serialize.length() > 0) {
                    SqlMapParser.this.vars.currentCacheModel.setSerialize("true".equals(serialize));
                } else {
                    SqlMapParser.this.vars.currentCacheModel.setSerialize(false);
                }
                SqlMapParser.this.vars.errorCtx.setObjectId(id + " cache model");
                SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the cache model type.");
                SqlMapParser.this.vars.currentCacheModel.setId(id);
                SqlMapParser.this.vars.currentCacheModel.setResource(SqlMapParser.this.vars.errorCtx.getResource());
                try {
                    SqlMapParser.this.vars.currentCacheModel.setControllerClassName(type);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error setting Cache Controller Class.  Cause: " + e, e);
                }
                SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the cache model configuration.");
                SqlMapParser.this.vars.currentCacheModel.configure(SqlMapParser.this.vars.currentProperties);
                if (SqlMapParser.this.vars.client.getDelegate().isCacheModelsEnabled()) {
                    SqlMapParser.this.vars.client.getDelegate().addCacheModel(SqlMapParser.this.vars.currentCacheModel);
                }
                SqlMapParser.this.vars.errorCtx.setMoreInfo(null);
                SqlMapParser.this.vars.errorCtx.setObjectId(null);
                SqlMapParser.this.vars.currentProperties = null;
                SqlMapParser.this.vars.currentCacheModel = null;
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/property", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the cache model properties.");
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String name = attributes.getProperty("name");
                String value = NodeletUtils.parsePropertyTokens(attributes.getProperty("value"), SqlMapParser.this.vars.properties);
                SqlMapParser.this.vars.currentProperties.put(name, value);
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/flushOnExecute", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the cache model flush on statement elements.");
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                SqlMapParser.this.vars.currentCacheModel.addFlushTriggerStatement(childAttributes.getProperty("statement"));
            }
        });
        this.parser.addNodelet("/sqlMap/cacheModel/flushInterval", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                long t = 0L;
                try {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the cache model flush interval.");
                    String milliseconds = childAttributes.getProperty("milliseconds");
                    String seconds = childAttributes.getProperty("seconds");
                    String minutes = childAttributes.getProperty("minutes");
                    String hours = childAttributes.getProperty("hours");
                    if (milliseconds != null) {
                        t += (long)Integer.parseInt(milliseconds);
                    }
                    if (seconds != null) {
                        t += (long)(Integer.parseInt(seconds) * 1000);
                    }
                    if (minutes != null) {
                        t += (long)(Integer.parseInt(minutes) * 60 * 1000);
                    }
                    if (hours != null) {
                        t += (long)(Integer.parseInt(hours) * 60 * 60 * 1000);
                    }
                    if (t < 1L) {
                        throw new RuntimeException("A flush interval must specify one or more of milliseconds, seconds, minutes or hours.");
                    }
                    SqlMapParser.this.vars.currentCacheModel.setFlushInterval(t);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Error building cache '" + SqlMapParser.this.vars.currentCacheModel.getId() + "' in '" + "resourceNAME" + "'.  Flush interval milliseconds must be a valid long integer value.  Cause: " + e, e);
                }
            }
        });
    }

    private void addParameterMapNodelets() {
        this.parser.addNodelet("/sqlMap/parameterMap/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentParameterMap.setParameterMappingList(SqlMapParser.this.vars.parameterMappingList);
                SqlMapParser.this.vars.client.getDelegate().addParameterMap(SqlMapParser.this.vars.currentParameterMap);
                SqlMapParser.this.vars.errorCtx.setMoreInfo(null);
                SqlMapParser.this.vars.errorCtx.setObjectId(null);
            }
        });
        this.parser.addNodelet("/sqlMap/parameterMap", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.errorCtx.setActivity("building a parameter map");
                SqlMapParser.this.vars.currentParameterMap = new BasicParameterMap(SqlMapParser.this.vars.client.getDelegate());
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String id = SqlMapParser.this.applyNamespace(attributes.getProperty("id"));
                String parameterClassName = attributes.getProperty("class");
                parameterClassName = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(parameterClassName);
                SqlMapParser.this.vars.currentParameterMap.setId(id);
                SqlMapParser.this.vars.currentParameterMap.setResource(SqlMapParser.this.vars.errorCtx.getResource());
                SqlMapParser.this.vars.errorCtx.setObjectId(id + " parameter map");
                Class parameterClass = null;
                try {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the parameter class.");
                    parameterClass = Resources.classForName(parameterClassName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                SqlMapParser.this.vars.currentParameterMap.setParameterClass(parameterClass);
                SqlMapParser.this.vars.parameterMappingList = new ArrayList();
                SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the parameter mappings.");
            }
        });
        this.parser.addNodelet("/sqlMap/parameterMap/parameter", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String propertyName = childAttributes.getProperty("property");
                String jdbcType = childAttributes.getProperty("jdbcType");
                String type = childAttributes.getProperty("typeName");
                String javaType = childAttributes.getProperty("javaType");
                String resultMap = childAttributes.getProperty("resultMap");
                String nullValue = childAttributes.getProperty("nullValue");
                String mode = childAttributes.getProperty("mode");
                String callback = childAttributes.getProperty("typeHandler");
                String numericScale = childAttributes.getProperty("numericScale");
                callback = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(callback);
                javaType = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(javaType);
                resultMap = SqlMapParser.this.applyNamespace(resultMap);
                SqlMapParser.this.vars.errorCtx.setObjectId(propertyName + " mapping of the " + SqlMapParser.this.vars.currentParameterMap.getId() + " parameter map");
                TypeHandler handler = null;
                if (callback != null) {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the parameter mapping typeHandler attribute '" + callback + "' (must be a TypeHandler or TypeHandlerCallback implementation).");
                    try {
                        Object impl = Resources.classForName(callback).newInstance();
                        if (impl instanceof TypeHandlerCallback) {
                            handler = new CustomTypeHandler((TypeHandlerCallback)impl);
                        }
                        if (impl instanceof TypeHandler) {
                            handler = (TypeHandler)impl;
                        }
                        throw new RuntimeException("The class '" + callback + "' is not a valid implementation of TypeHandler or TypeHandlerCallback");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error occurred during custom type handler configuration.  Cause: " + e, e);
                    }
                } else {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the parameter mapping property type or name.");
                    handler = SqlMapParser.this.resolveTypeHandler(SqlMapParser.this.vars.client.getDelegate().getTypeHandlerFactory(), SqlMapParser.this.vars.currentParameterMap.getParameterClass(), propertyName, javaType, jdbcType);
                }
                BasicParameterMapping mapping = new BasicParameterMapping();
                mapping.setPropertyName(propertyName);
                mapping.setJdbcTypeName(jdbcType);
                mapping.setTypeName(type);
                mapping.setResultMapName(resultMap);
                mapping.setNullValue(nullValue);
                if (mode != null && mode.length() > 0) {
                    mapping.setMode(mode);
                }
                mapping.setTypeHandler(handler);
                try {
                    if (javaType != null && javaType.length() > 0) {
                        mapping.setJavaType(Resources.classForName(javaType));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting javaType on parameter mapping.  Cause: " + e);
                }
                if (numericScale != null) {
                    try {
                        Integer scale = Integer.valueOf(numericScale);
                        if (scale < 0) {
                            throw new RuntimeException("Error setting numericScale on parameter mapping.  Cause: scale must be greater than or equal to zero");
                        }
                        mapping.setNumericScale(scale);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Error setting numericScale on parameter mapping.  Cause: " + numericScale + " is not a valid integer");
                    }
                }
                SqlMapParser.this.vars.parameterMappingList.add(mapping);
            }
        });
    }

    private void addResultMapNodelets() {
        this.parser.addNodelet("/sqlMap/resultMap/end()", new Nodelet(){

            public void process(Node node) throws Exception {
                if (SqlMapParser.this.vars.resultMappingList.size() == 0) {
                    throw new RuntimeException("resultMap " + SqlMapParser.this.vars.currentResultMap.getId() + " must have at least one result mapping");
                }
                SqlMapParser.this.vars.currentResultMap.setResultMappingList(SqlMapParser.this.vars.resultMappingList);
                SqlMapParser.this.vars.currentResultMap.setDiscriminator(SqlMapParser.this.vars.discriminator);
                SqlMapParser.this.vars.discriminator = null;
                SqlMapParser.this.vars.client.getDelegate().addResultMap(SqlMapParser.this.vars.currentResultMap);
                SqlMapParser.this.vars.errorCtx.setMoreInfo(null);
                SqlMapParser.this.vars.errorCtx.setObjectId(null);
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.errorCtx.setActivity("building a result map");
                SqlMapParser.this.vars.currentResultMap = new BasicResultMap(SqlMapParser.this.vars.client.getDelegate());
                Properties attributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String id = SqlMapParser.this.applyNamespace(attributes.getProperty("id"));
                String resultClassName = attributes.getProperty("class");
                String extended = SqlMapParser.this.applyNamespace(attributes.getProperty("extends"));
                String xmlName = attributes.getProperty("xmlName");
                String groupBy = attributes.getProperty("groupBy");
                resultClassName = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(resultClassName);
                SqlMapParser.this.vars.errorCtx.setObjectId(id + " result map");
                SqlMapParser.this.vars.currentResultMap.setId(id);
                SqlMapParser.this.vars.currentResultMap.setXmlName(xmlName);
                SqlMapParser.this.vars.currentResultMap.setResource(SqlMapParser.this.vars.errorCtx.getResource());
                if (groupBy != null && groupBy.length() > 0) {
                    StringTokenizer parser = new StringTokenizer(groupBy, ", ", false);
                    while (parser.hasMoreTokens()) {
                        SqlMapParser.this.vars.currentResultMap.addGroupByProperty(parser.nextToken());
                    }
                }
                Class resultClass = null;
                try {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the result class.");
                    resultClass = Resources.classForName(resultClassName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error configuring Result.  Could not set ResultClass.  Cause: " + e, e);
                }
                SqlMapParser.this.vars.currentResultMap.setResultClass(resultClass);
                SqlMapParser.this.vars.resultMappingList = new ArrayList();
                SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the extended result map.");
                if (extended != null) {
                    BasicResultMap extendedResultMap = (BasicResultMap)SqlMapParser.this.vars.client.getDelegate().getResultMap(extended);
                    ResultMapping[] resultMappings = extendedResultMap.getResultMappings();
                    for (int i = 0; i < resultMappings.length; ++i) {
                        SqlMapParser.this.vars.resultMappingList.add(resultMappings[i]);
                    }
                    List nestedResultMappings = extendedResultMap.getNestedResultMappings();
                    if (nestedResultMappings != null) {
                        Iterator iter = nestedResultMappings.iterator();
                        while (iter.hasNext()) {
                            SqlMapParser.this.vars.currentResultMap.addNestedResultMappings((ResultMapping)iter.next());
                        }
                    }
                    if ((groupBy == null || groupBy.length() == 0) && extendedResultMap.hasGroupBy()) {
                        Iterator i = extendedResultMap.groupByProps();
                        while (i.hasNext()) {
                            SqlMapParser.this.vars.currentResultMap.addGroupByProperty((String)i.next());
                        }
                    }
                }
                SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the result mappings.");
                SqlMapParser.this.vars.resultMappingIndex = SqlMapParser.this.vars.resultMappingList.size();
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap/result", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String propertyName = childAttributes.getProperty("property");
                String nullValue = childAttributes.getProperty("nullValue");
                String jdbcType = childAttributes.getProperty("jdbcType");
                String javaType = childAttributes.getProperty("javaType");
                String columnName = childAttributes.getProperty("column");
                String columnIndex = childAttributes.getProperty("columnIndex");
                String statementName = childAttributes.getProperty("select");
                String resultMapName = childAttributes.getProperty("resultMap");
                String callback = childAttributes.getProperty("typeHandler");
                callback = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(callback);
                javaType = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(javaType);
                SqlMapParser.this.vars.errorCtx.setObjectId(propertyName + " mapping of the " + SqlMapParser.this.vars.currentResultMap.getId() + " result map");
                TypeHandler handler = null;
                if (callback != null) {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the result mapping typeHandler attribute '" + callback + "' (must be a TypeHandler or TypeHandlerCallback implementation).");
                    try {
                        Object impl = Resources.classForName(callback).newInstance();
                        if (impl instanceof TypeHandlerCallback) {
                            handler = new CustomTypeHandler((TypeHandlerCallback)impl);
                        }
                        if (impl instanceof TypeHandler) {
                            handler = (TypeHandler)impl;
                        }
                        throw new RuntimeException("The class '" + callback + "' is not a valid implementation of TypeHandler or TypeHandlerCallback");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error occurred during custom type handler configuration.  Cause: " + e, e);
                    }
                } else {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the result mapping property type or name.");
                    handler = SqlMapParser.this.resolveTypeHandler(SqlMapParser.this.vars.client.getDelegate().getTypeHandlerFactory(), SqlMapParser.this.vars.currentResultMap.getResultClass(), propertyName, javaType, jdbcType, true);
                }
                BasicResultMapping mapping = new BasicResultMapping();
                mapping.setPropertyName(propertyName);
                mapping.setColumnName(columnName);
                mapping.setJdbcTypeName(jdbcType);
                mapping.setTypeHandler(handler);
                mapping.setNullValue(nullValue);
                mapping.setStatementName(statementName);
                mapping.setNestedResultMapName(resultMapName);
                if (resultMapName != null && resultMapName.length() > 0) {
                    SqlMapParser.this.vars.currentResultMap.addNestedResultMappings(mapping);
                }
                try {
                    if (javaType != null && javaType.length() > 0) {
                        mapping.setJavaType(Resources.classForName(javaType));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting javaType on result mapping.  Cause: " + e);
                }
                if (columnIndex != null && columnIndex.length() > 0) {
                    mapping.setColumnIndex(Integer.parseInt(columnIndex));
                } else {
                    ++SqlMapParser.this.vars.resultMappingIndex;
                    mapping.setColumnIndex(SqlMapParser.this.vars.resultMappingIndex);
                }
                SqlMapParser.this.vars.resultMappingList.add(mapping);
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap/discriminator/subMap", new Nodelet(){

            public void process(Node node) throws Exception {
                if (SqlMapParser.this.vars.discriminator == null) {
                    throw new RuntimeException("The discriminator is null, but somehow a subMap was reached.  This is a bug.");
                }
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String value = childAttributes.getProperty("value");
                String resultMap = childAttributes.getProperty("resultMap");
                SqlMapParser.this.vars.discriminator.addSubMap(value, SqlMapParser.this.applyNamespace(resultMap));
            }
        });
        this.parser.addNodelet("/sqlMap/resultMap/discriminator", new Nodelet(){

            public void process(Node node) throws Exception {
                Properties childAttributes = NodeletUtils.parseAttributes(node, SqlMapParser.this.vars.properties);
                String nullValue = childAttributes.getProperty("nullValue");
                String jdbcType = childAttributes.getProperty("jdbcType");
                String javaType = childAttributes.getProperty("javaType");
                String columnName = childAttributes.getProperty("column");
                String columnIndex = childAttributes.getProperty("columnIndex");
                String callback = childAttributes.getProperty("typeHandler");
                callback = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(callback);
                javaType = SqlMapParser.this.vars.typeHandlerFactory.resolveAlias(javaType);
                TypeHandler handler = null;
                if (callback != null) {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the result mapping typeHandler attribute '" + callback + "' (must be a TypeHandlerCallback implementation).");
                    try {
                        Object impl = Resources.classForName(callback).newInstance();
                        if (impl instanceof TypeHandlerCallback) {
                            handler = new CustomTypeHandler((TypeHandlerCallback)impl);
                        }
                        if (impl instanceof TypeHandler) {
                            handler = (TypeHandler)impl;
                        }
                        throw new RuntimeException("The class '' is not a valid implementation of TypeHandler or TypeHandlerCallback");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error occurred during custom type handler configuration.  Cause: " + e, e);
                    }
                } else {
                    SqlMapParser.this.vars.errorCtx.setMoreInfo("Check the result mapping property type or name.");
                    handler = SqlMapParser.this.resolveTypeHandler(SqlMapParser.this.vars.client.getDelegate().getTypeHandlerFactory(), SqlMapParser.this.vars.currentResultMap.getResultClass(), "", javaType, jdbcType, true);
                }
                BasicResultMapping mapping = new BasicResultMapping();
                mapping.setColumnName(columnName);
                mapping.setJdbcTypeName(jdbcType);
                mapping.setTypeHandler(handler);
                mapping.setNullValue(nullValue);
                try {
                    if (javaType != null && javaType.length() > 0) {
                        mapping.setJavaType(Resources.classForName(javaType));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting javaType on result mapping.  Cause: " + e);
                }
                if (columnIndex != null && columnIndex.length() > 0) {
                    mapping.setColumnIndex(Integer.parseInt(columnIndex));
                }
                SqlMapParser.this.vars.discriminator = new Discriminator(SqlMapParser.this.vars.delegate, mapping);
            }
        });
    }

    protected void addStatementNodelets() {
        this.parser.addNodelet("/sqlMap/statement", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentStatement = new SqlStatementParser(SqlMapParser.this.vars).parseGeneralStatement(node, new GeneralStatement());
                SqlMapParser.this.vars.delegate.addMappedStatement(SqlMapParser.this.vars.currentStatement);
            }
        });
        this.parser.addNodelet("/sqlMap/insert", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentStatement = new SqlStatementParser(SqlMapParser.this.vars).parseGeneralStatement(node, new InsertStatement());
                SqlMapParser.this.vars.delegate.addMappedStatement(SqlMapParser.this.vars.currentStatement);
            }
        });
        this.parser.addNodelet("/sqlMap/update", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentStatement = new SqlStatementParser(SqlMapParser.this.vars).parseGeneralStatement(node, new UpdateStatement());
                SqlMapParser.this.vars.delegate.addMappedStatement(SqlMapParser.this.vars.currentStatement);
            }
        });
        this.parser.addNodelet("/sqlMap/delete", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentStatement = new SqlStatementParser(SqlMapParser.this.vars).parseGeneralStatement(node, new DeleteStatement());
                SqlMapParser.this.vars.delegate.addMappedStatement(SqlMapParser.this.vars.currentStatement);
            }
        });
        this.parser.addNodelet("/sqlMap/select", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentStatement = new SqlStatementParser(SqlMapParser.this.vars).parseGeneralStatement(node, new SelectStatement());
                SqlMapParser.this.vars.delegate.addMappedStatement(SqlMapParser.this.vars.currentStatement);
            }
        });
        this.parser.addNodelet("/sqlMap/procedure", new Nodelet(){

            public void process(Node node) throws Exception {
                SqlMapParser.this.vars.currentStatement = new SqlStatementParser(SqlMapParser.this.vars).parseGeneralStatement(node, new ProcedureStatement());
                SqlMapParser.this.vars.delegate.addMappedStatement(SqlMapParser.this.vars.currentStatement);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

