/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.bytecode;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectfactory.ObjectChanger;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectfactory.ObjectResolver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class ObjectResolveAndObjectChangedEnhancerAbstract {
    protected final ObjectResolver objectResolver;
    protected final ObjectChanger objectChanger;
    protected final SpecificationLoader specificationLoader;

    public ObjectResolveAndObjectChangedEnhancerAbstract(ObjectResolver objectResolver, ObjectChanger objectChanger, SpecificationLoader specificationLoader) {
        Ensure.ensureThatArg((Object)objectResolver, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)objectChanger, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.objectResolver = objectResolver;
        this.objectChanger = objectChanger;
        this.specificationLoader = specificationLoader;
    }

    protected abstract void createCallback();

    protected ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    protected ObjectSpecificationDefault getJavaSpecification(Class<?> cls) {
        ObjectSpecification nos = this.getSpecification(cls);
        if (!(nos instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + nos.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)nos;
    }

    protected boolean impliesResolve(ImperativeFacet[] imperativeFacets) {
        for (ImperativeFacet imperativeFacet : imperativeFacets) {
            if (!imperativeFacet.impliesResolve()) continue;
            return true;
        }
        return false;
    }

    protected boolean impliesObjectChanged(ImperativeFacet[] imperativeFacets) {
        for (ImperativeFacet imperativeFacet : imperativeFacets) {
            if (!imperativeFacet.impliesObjectChanged()) continue;
            return true;
        }
        return false;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        return this.specificationLoader.loadSpecification(type);
    }

    public final ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public final ObjectChanger getObjectChanger() {
        return this.objectChanger;
    }

    public final SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }
}

