/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.fixtures;

import org.apache.isis.applib.profiles.Perspective;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.runtime.userprofile.PerspectiveEntry;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;

class PerspectiveImpl
implements Perspective {
    private final PerspectiveEntry entry;

    public PerspectiveImpl(PerspectiveEntry perspectiveEntry) {
        this.entry = perspectiveEntry;
    }

    public PerspectiveEntry getPerspectiveEntry() {
        return this.entry;
    }

    public void addGenericRepository(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            Object service = this.getPersistenceSession().getService("repository#" + cls.getName()).getObject();
            this.entry.addToServices(service);
        }
    }

    public void addToObjects(Object ... objects) {
        for (Object object : objects) {
            this.entry.addToObjects(object);
        }
    }

    public Object addToServices(Class<?> serviceType) {
        Object service = this.findService(serviceType);
        this.entry.addToServices(service);
        return service;
    }

    public void removeFromServices(Class<?> serviceType) {
        Object service = this.findService(serviceType);
        this.entry.removeFromServices(service);
    }

    private Object findService(Class<?> serviceType) {
        for (Object service : IsisContext.getServices()) {
            if (!service.getClass().isAssignableFrom(serviceType)) continue;
            return service;
        }
        throw new IsisException("No service of type " + serviceType.getName());
    }

    public void addToServices(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            this.addToServices(cls);
        }
    }

    public void removeFromServices(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            this.removeFromServices(cls);
        }
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

