/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.fixtures;

import java.util.List;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserService;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserServiceAware;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.runtimes.dflt.runtime.fixtures.authentication.AuthenticationRequestLogonFixture;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;

public class SwitchUserServiceImpl
implements SwitchUserService {
    public void switchUser(String username, List<String> roles) {
        this.switchUser(new LogonFixture(username, roles));
    }

    public void switchUser(String username, String ... roles) {
        this.switchUser(new LogonFixture(username, roles));
    }

    private void switchUser(LogonFixture logonFixture) {
        this.getTransactionManager().endTransaction();
        IsisContext.closeSession();
        AuthenticationRequestLogonFixture authRequest = new AuthenticationRequestLogonFixture(logonFixture);
        AuthenticationSession session = this.getAuthenticationManager().authenticate((AuthenticationRequest)authRequest);
        IsisContext.openSession(session);
        this.getTransactionManager().startTransaction();
    }

    public void injectInto(Object fixture) {
        if (fixture instanceof SwitchUserServiceAware) {
            SwitchUserServiceAware serviceAware = (SwitchUserServiceAware)fixture;
            serviceAware.setService((SwitchUserService)this);
        }
    }

    protected AuthenticationManager getAuthenticationManager() {
        return IsisContext.getAuthenticationManager();
    }

    protected IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }
}

