/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi;

import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.PersistenceMechanismInstallerAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.IsisStoreLogger;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStore;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStorePersistence;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.PersistenceSessionObjectStore;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.dflt.DefaultPersistAlgorithm;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.AdapterManager;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.ObjectFactory;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.OidGenerator;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionTransactionManagement;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class ObjectStorePersistenceMechanismInstallerAbstract
extends PersistenceMechanismInstallerAbstract {
    private static final String LOGGING_PROPERTY = "isis.logging.objectstore";

    public ObjectStorePersistenceMechanismInstallerAbstract(String name) {
        super(name);
    }

    @Override
    protected PersistenceSession createPersistenceSession(PersistenceSessionFactory persistenceSessionFactory, AdapterManagerExtended adapterManager, ObjectAdapterFactory adapterFactory, ObjectFactory objectFactory, OidGenerator oidGenerator, ServicesInjector servicesInjector) {
        PersistAlgorithm persistAlgorithm = this.createPersistAlgorithm(this.getConfiguration());
        ObjectStore objectStore = this.createObjectStore(this.getConfiguration(), adapterFactory, adapterManager);
        Ensure.ensureThatArg((Object)persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        if (this.getConfiguration().getBoolean(LOGGING_PROPERTY, false)) {
            String level = this.getConfiguration().getString("isis.logging.objectstore.level", "debug");
            objectStore = new IsisStoreLogger(objectStore, level);
        }
        PersistenceSessionObjectStore persistenceSession = this.createObjectStorePersistor(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, oidGenerator, adapterManager, persistAlgorithm, objectStore);
        IsisTransactionManager transactionManager = this.createTransactionManager(persistenceSession, objectStore);
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        persistenceSession.setDirtiableSupport(true);
        transactionManager.injectInto(persistenceSession);
        return persistenceSession;
    }

    protected PersistenceSessionObjectStore createObjectStorePersistor(PersistenceSessionFactory persistenceSessionFactory, ObjectAdapterFactory adapterFactory, ObjectFactory objectFactory, ServicesInjector servicesInjector, OidGenerator oidGenerator, AdapterManagerExtended adapterManager, PersistAlgorithm persistAlgorithm, ObjectStorePersistence objectStore) {
        return new PersistenceSessionObjectStore(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, oidGenerator, adapterManager, persistAlgorithm, objectStore);
    }

    protected PersistAlgorithm createPersistAlgorithm(IsisConfiguration configuration) {
        return new DefaultPersistAlgorithm();
    }

    protected IsisTransactionManager createTransactionManager(PersistenceSessionTransactionManagement persistor, ObjectStoreTransactionManagement objectStore) {
        return new ObjectStoreTransactionManager(persistor, objectStore);
    }

    protected abstract ObjectStore createObjectStore(IsisConfiguration var1, ObjectAdapterFactory var2, AdapterManager var3);
}

