/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi;

import java.util.List;
import java.util.Properties;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookup;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookupAware;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.runtimes.dflt.runtime.persistence.PersistenceConstants;
import org.apache.isis.runtimes.dflt.runtime.persistence.PersistenceSessionLogger;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.apache.isis.runtimes.dflt.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.ObjectFactory;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.OidGenerator;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.systemdependencyinjector.SystemDependencyInjector;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class PersistenceMechanismInstallerAbstract
extends InstallerAbstract
implements PersistenceMechanismInstaller,
InstallerLookupAware {
    private static final String LOGGING_PROPERTY = "isis.logging.persistenceSession";
    private static final Logger LOG = Logger.getLogger(PersistenceMechanismInstallerAbstract.class);
    private SystemDependencyInjector installerLookup;

    public PersistenceMechanismInstallerAbstract(String name) {
        super("persistor", name);
    }

    public PersistenceMechanismInstallerAbstract(String type, String name) {
        super(type, name);
    }

    @Override
    public PersistenceSession createPersistenceSession(PersistenceSessionFactory persistenceSessionFactory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("installing " + this.getClass().getName()));
        }
        AdapterManagerExtended adapterManager = this.createAdapterManager(this.getConfiguration());
        ObjectAdapterFactory adapterFactory = this.createAdapterFactory(this.getConfiguration());
        ObjectFactory objectFactory = this.createObjectFactory(this.getConfiguration());
        OidGenerator oidGenerator = this.createOidGenerator(this.getConfiguration());
        RuntimeContext runtimeContext = this.createRuntimeContext(this.getConfiguration());
        DomainObjectContainer container = this.createContainer(this.getConfiguration());
        ServicesInjector servicesInjector = this.createServicesInjector(this.getConfiguration());
        List<Object> serviceList = persistenceSessionFactory.getServices();
        Ensure.ensureThatArg((Object)adapterManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)objectFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)oidGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)runtimeContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)container, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(serviceList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)servicesInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        runtimeContext.injectInto((Object)container);
        runtimeContext.setContainer(container);
        servicesInjector.setContainer(container);
        servicesInjector.setServices(serviceList);
        persistenceSessionFactory.getSpecificationLoader().injectInto((Object)runtimeContext);
        PersistenceSession persistenceSession = this.createPersistenceSession(persistenceSessionFactory, adapterManager, adapterFactory, objectFactory, oidGenerator, servicesInjector);
        if (this.getConfiguration().getBoolean(LOGGING_PROPERTY, false)) {
            String level = this.getConfiguration().getString("isis.logging.persistenceSession.level", "debug");
            persistenceSession = new PersistenceSessionLogger(persistenceSession, level);
        }
        return persistenceSession;
    }

    protected abstract PersistenceSession createPersistenceSession(PersistenceSessionFactory var1, AdapterManagerExtended var2, ObjectAdapterFactory var3, ObjectFactory var4, OidGenerator var5, ServicesInjector var6);

    protected ObjectAdapterFactory createAdapterFactory(IsisConfiguration configuration) {
        String configuredClassName = configuration.getString("isis.persistor.adapter-factory", PersistenceConstants.ADAPTER_FACTORY_CLASS_NAME_DEFAULT);
        return (ObjectAdapterFactory)InstanceUtil.createInstance((String)configuredClassName, ObjectAdapterFactory.class);
    }

    protected ObjectFactory createObjectFactory(IsisConfiguration configuration) {
        String configuredClassName = configuration.getString("isis.persistor.object-factory", "org.apache.isis.runtimes.dflt.bytecode.dflt.objectfactory.CglibObjectFactory");
        return (ObjectFactory)InstanceUtil.createInstance((String)configuredClassName, (String)"org.apache.isis.runtimes.dflt.bytecode.dflt.objectfactory.CglibObjectFactory", ObjectFactory.class);
    }

    protected ServicesInjector createServicesInjector(IsisConfiguration configuration) {
        String configuredClassName = configuration.getString("isis.persistor.services-injector", PersistenceConstants.SERVICES_INJECTOR_CLASS_NAME_DEFAULT);
        return (ServicesInjector)InstanceUtil.createInstance((String)configuredClassName, ServicesInjector.class);
    }

    protected OidGenerator createOidGenerator(IsisConfiguration configuration) {
        String oidGeneratorClassName = configuration.getString("isis.persistor.oid-generator", PersistenceConstants.OID_GENERATOR_CLASS_NAME_DEFAULT);
        return (OidGenerator)InstanceUtil.createInstance((String)oidGeneratorClassName, OidGenerator.class);
    }

    protected AdapterManagerExtended createAdapterManager(IsisConfiguration configuration) {
        return new AdapterManagerDefault();
    }

    protected RuntimeContext createRuntimeContext(IsisConfiguration configuration) {
        Properties properties = new Properties();
        IsisConfiguration applicationConfiguration = configuration.getProperties("application");
        for (String key : applicationConfiguration) {
            String value = applicationConfiguration.getString(key);
            String newKey = key.substring("application.".length());
            properties.setProperty(newKey, value);
        }
        RuntimeContextFromSession runtimeContext = new RuntimeContextFromSession();
        runtimeContext.setProperties(properties);
        return runtimeContext;
    }

    protected DomainObjectContainer createContainer(IsisConfiguration configuration) {
        String configuredClassName = configuration.getString("isis.persistor.domain-object-container", PersistenceConstants.DOMAIN_OBJECT_CONTAINER_NAME_DEFAULT);
        return (DomainObjectContainer)InstanceUtil.createInstance((String)configuredClassName, (String)PersistenceConstants.DOMAIN_OBJECT_CONTAINER_NAME_DEFAULT, DomainObjectContainer.class);
    }

    @Override
    public void setInstallerLookup(InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
    }

    protected SystemDependencyInjector getInstallerLookup() {
        return this.installerLookup;
    }

    public List<Class<?>> getTypes() {
        return PersistenceMechanismInstallerAbstract.listOf((Class[])new Class[]{PersistenceSessionFactory.class});
    }
}

