/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.installers;

import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.components.Installer;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.factory.UnavailableClassException;
import org.apache.isis.core.commons.lang.CastUtils;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.runtime.authentication.AuthenticationManagerInstaller;
import org.apache.isis.core.runtime.authorization.AuthorizationManagerInstaller;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoaderInstaller;
import org.apache.isis.runtimes.dflt.runtime.IsisInstallerRegistry;
import org.apache.isis.runtimes.dflt.runtime.fixtures.FixturesInstaller;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookup;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookupAware;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.ClientConnectionInstaller;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.EmbeddedWebServerInstaller;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.IsisViewerInstaller;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.runtimes.dflt.runtime.services.ServicesInstaller;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.isis.runtimes.dflt.runtime.systemdependencyinjector.SystemDependencyInjectorAware;
import org.apache.isis.runtimes.dflt.runtime.userprofile.UserProfileStoreInstaller;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class InstallerLookupDefault
implements InstallerLookup {
    private static final Logger LOG = Logger.getLogger(InstallerLookupDefault.class);
    private final List<Installer> installerList = new ArrayList<Installer>();
    private IsisConfigurationBuilder isisConfigurationBuilder;

    public InstallerLookupDefault() {
        this.loadInstallers();
    }

    /*
     * Exception decompiling
     */
    private void loadInstallers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Installer[] getInstallers(Class<?> cls) {
        ArrayList<Installer> list = new ArrayList<Installer>();
        for (Installer comp : this.installerList) {
            if (!cls.isAssignableFrom(comp.getClass())) continue;
            list.add(comp);
        }
        return list.toArray(new Installer[list.size()]);
    }

    public void init() {
        this.ensureDependenciesInjected();
    }

    private void ensureDependenciesInjected() {
        Ensure.ensureThatState((Object)this.isisConfigurationBuilder, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    public void shutdown() {
    }

    @Override
    public AuthenticationManagerInstaller authenticationManagerInstaller(String requested, DeploymentType deploymentType) {
        return this.getInstaller(AuthenticationManagerInstaller.class, requested, "isis.authentication", deploymentType.isExploring() ? "noop" : "file");
    }

    @Override
    public AuthorizationManagerInstaller authorizationManagerInstaller(String requested, DeploymentType deploymentType) {
        return this.getInstaller(AuthorizationManagerInstaller.class, requested, "isis.authorization", !deploymentType.isProduction() ? "noop" : "file");
    }

    @Override
    public FixturesInstaller fixturesInstaller(String requested) {
        return this.getInstaller(FixturesInstaller.class, requested, "isis.fixtures-installer", "configuration");
    }

    @Override
    public TemplateImageLoaderInstaller templateImageLoaderInstaller(String requested) {
        return this.getInstaller(TemplateImageLoaderInstaller.class, requested, "isis.template-image-loader", "awt");
    }

    @Override
    public PersistenceMechanismInstaller persistenceMechanismInstaller(String requested, DeploymentType deploymentType) {
        String persistorDefault = deploymentType.isExploring() || deploymentType.isPrototyping() ? "in-memory" : "xml";
        return this.getInstaller(PersistenceMechanismInstaller.class, requested, "isis.persistor", persistorDefault);
    }

    @Override
    public UserProfileStoreInstaller userProfilePersistenceMechanismInstaller(String requested, DeploymentType deploymentType) {
        String profileStoreDefault = deploymentType.isExploring() || deploymentType.isPrototyping() ? "in-memory" : "xml";
        return this.getInstaller(UserProfileStoreInstaller.class, requested, "isis.user-profile-store", profileStoreDefault);
    }

    @Override
    public ObjectReflectorInstaller reflectorInstaller(String requested) {
        return this.getInstaller(ObjectReflectorInstaller.class, requested, "isis.reflector", "java");
    }

    @Override
    public EmbeddedWebServerInstaller embeddedWebServerInstaller(String requested) {
        return this.getInstaller(EmbeddedWebServerInstaller.class, requested, "isis.embedded-web-server", "jetty");
    }

    @Override
    public ClientConnectionInstaller clientConnectionInstaller(String requested) {
        return this.getInstaller(ClientConnectionInstaller.class, requested, "isis.connector", "encoding_socket");
    }

    @Override
    public IsisViewerInstaller viewerInstaller(String name, String defaultName) {
        String viewer = name == null ? this.getConfiguration().getString("isis.viewer", defaultName) : name;
        if (viewer == null) {
            return null;
        }
        return this.getInstaller(IsisViewerInstaller.class, viewer);
    }

    @Override
    public IsisViewerInstaller viewerInstaller(String name) {
        IsisViewerInstaller installer = this.getInstaller(IsisViewerInstaller.class, name);
        if (installer == null) {
            throw new IsisException("No viewer installer of type " + name);
        }
        return installer;
    }

    @Override
    public ServicesInstaller servicesInstaller(String requestedImplementationName) {
        return this.getInstaller(ServicesInstaller.class, requestedImplementationName, "isis.services-installer", "configuration");
    }

    @Override
    public <T extends Installer> T getInstaller(Class<T> cls, String implName) {
        Assert.assertNotNull((String)"No name specified", (Object)implName);
        for (Installer installer : this.installerList) {
            if (!cls.isAssignableFrom(installer.getClass()) || !installer.getName().equals(implName)) continue;
            this.mergeConfigurationFor(installer);
            this.injectDependenciesInto(installer);
            return (T)installer;
        }
        return (T)this.getInstaller(implName);
    }

    public Installer getInstaller(String implClassName) {
        try {
            Installer installer = (Installer)CastUtils.cast((Object)InstanceUtil.createInstance((String)implClassName));
            if (installer != null) {
                this.mergeConfigurationFor(installer);
                this.injectDependenciesInto(installer);
            }
            return installer;
        }
        catch (InstanceCreationException e) {
            throw new InstanceCreationException("Specification error in installer-registry.properties", (Throwable)e);
        }
        catch (UnavailableClassException e) {
            return null;
        }
    }

    @Override
    public <T extends Installer> T getInstaller(Class<T> installerCls) {
        try {
            Installer installer = (Installer)InstanceUtil.createInstance(installerCls);
            if (installer != null) {
                this.mergeConfigurationFor(installer);
                this.injectDependenciesInto(installer);
            }
            return (T)installer;
        }
        catch (InstanceCreationException e) {
            throw new InstanceCreationException("Specification error in installer-registry.properties", (Throwable)e);
        }
        catch (UnavailableClassException e) {
            return null;
        }
    }

    private <T extends Installer> T getInstaller(Class<T> requiredType, String reqImpl, String key, String defaultImpl) {
        if (reqImpl == null) {
            reqImpl = this.getConfiguration().getString(key, defaultImpl);
        }
        if (reqImpl == null) {
            return null;
        }
        T installer = this.getInstaller(requiredType, reqImpl);
        if (installer == null) {
            throw new InstanceCreationException("Failed to load installer; named/class:'" + reqImpl + "' (of type " + requiredType.getName() + ")");
        }
        return installer;
    }

    private void close(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IsisException((Throwable)e);
            }
        }
    }

    private InputStream getInstallerRegistryStream(String componentFile) {
        InputStream in = IsisInstallerRegistry.getPropertiesAsStream();
        if (in == null) {
            throw new IsisException("No resource found: " + componentFile);
        }
        return in;
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return this.isisConfigurationBuilder.getConfiguration();
    }

    public void mergeConfigurationFor(Installer installer) {
        for (String installerConfigResource : installer.getConfigurationResources()) {
            this.isisConfigurationBuilder.addConfigurationResource(installerConfigResource, NotFoundPolicy.CONTINUE);
        }
    }

    @Override
    public <T> T injectDependenciesInto(T candidate) {
        this.injectInto(candidate);
        return candidate;
    }

    public void injectInto(Object candidate) {
        Object cast;
        if (SystemDependencyInjectorAware.class.isAssignableFrom(candidate.getClass())) {
            cast = (SystemDependencyInjectorAware)SystemDependencyInjectorAware.class.cast(candidate);
            cast.setSystemDependencyInjector(this);
        }
        if (InstallerLookupAware.class.isAssignableFrom(candidate.getClass())) {
            cast = (InstallerLookupAware)InstallerLookupAware.class.cast(candidate);
            cast.setInstallerLookup(this);
        }
        this.isisConfigurationBuilder.injectInto(candidate);
    }

    @Override
    public IsisConfigurationBuilder getConfigurationBuilder() {
        return this.isisConfigurationBuilder;
    }

    @Inject
    public void setConfigurationBuilder(IsisConfigurationBuilder configurationLoader) {
        this.isisConfigurationBuilder = configurationLoader;
    }
}

