/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.memento;

import java.io.IOException;
import java.io.Serializable;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.metamodel.adapter.oid.Oid;

public class Data
implements Encodable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String resolveState;
    private final Oid oid;

    public Data(Oid oid, String resolveState, String className) {
        this.className = className;
        this.resolveState = resolveState;
        this.oid = oid;
        this.initialized();
    }

    public Data(DataInputExtended input) throws IOException {
        this.className = input.readUTF();
        this.resolveState = input.readUTF();
        this.oid = (Oid)input.readEncodable(Oid.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.className);
        output.writeUTF(this.resolveState);
        output.writeEncodable((Object)this.oid);
    }

    private void initialized() {
    }

    public Oid getOid() {
        return this.oid;
    }

    public String getClassName() {
        return this.className;
    }

    public String getResolveState() {
        return this.resolveState;
    }

    public void debug(DebugBuilder debug) {
        debug.appendln(this.className);
        debug.appendln(this.oid != null ? this.oid.toString() : "null");
        debug.appendln(this.resolveState);
    }

    public String toString() {
        return this.className + "/" + this.oid;
    }
}

