/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.memento;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.encoding.DataInputStreamExtended;
import org.apache.isis.core.commons.encoding.DataOutputStreamExtended;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.runtimes.dflt.runtime.memento.CollectionData;
import org.apache.isis.runtimes.dflt.runtime.memento.Data;
import org.apache.isis.runtimes.dflt.runtime.memento.ObjectData;
import org.apache.isis.runtimes.dflt.runtime.memento.StandaloneData;
import org.apache.isis.runtimes.dflt.runtime.persistence.PersistorUtil;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionHydrator;
import org.apache.log4j.Logger;

public class Memento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Memento.class);
    private final List<Oid> transientObjects = Lists.newArrayList();
    private Data state;

    public Memento(ObjectAdapter object) {
        Data data = this.state = object == null ? null : this.createData(object);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("created memento for " + this));
        }
    }

    private Data createData(ObjectAdapter object) {
        if (object.getSpecification().isCollection()) {
            return this.createCollectionData(object);
        }
        return this.createObjectData(object);
    }

    private Data createCollectionData(ObjectAdapter object) {
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)object);
        Data[] collData = new Data[facet.size(object)];
        int i = 0;
        for (ObjectAdapter ref : facet.iterable(object)) {
            collData[i++] = this.createReferenceData(ref);
        }
        String elementTypeSpecName = object.getSpecification().getFullIdentifier();
        return new CollectionData(object.getOid(), object.getResolveState(), elementTypeSpecName, collData);
    }

    private ObjectData createObjectData(ObjectAdapter adapter) {
        this.transientObjects.add(adapter.getOid());
        ObjectSpecification cls = adapter.getSpecification();
        List fields = cls.getAssociations();
        ObjectData data = new ObjectData(adapter.getOid(), adapter.getResolveState().name(), cls.getFullIdentifier());
        for (int i = 0; i < fields.size(); ++i) {
            if (((ObjectAssociation)fields.get(i)).isNotPersisted()) {
                if (((ObjectAssociation)fields.get(i)).isOneToManyAssociation()) continue;
                if (((ObjectAssociation)fields.get(i)).containsFacet(PropertyOrCollectionAccessorFacet.class) && !((ObjectAssociation)fields.get(i)).containsFacet(PropertySetterFacet.class)) {
                    LOG.debug((Object)("ignoring not-settable field " + ((ObjectAssociation)fields.get(i)).getName()));
                    continue;
                }
            }
            this.createFieldData(adapter, data, (ObjectAssociation)fields.get(i));
        }
        return data;
    }

    private void createFieldData(ObjectAdapter object, ObjectData data, ObjectAssociation field) {
        Object fieldData;
        if (field.isOneToManyAssociation()) {
            ObjectAdapter coll = field.get(object);
            fieldData = this.createCollectionData(coll);
        } else if (field.getSpecification().isEncodeable()) {
            EncodableFacet facet = (EncodableFacet)field.getSpecification().getFacet(EncodableFacet.class);
            ObjectAdapter value = field.get(object);
            fieldData = facet.toEncodedString(value);
        } else if (field.isOneToOneAssociation()) {
            ObjectAdapter ref = ((OneToOneAssociation)field).get(object);
            fieldData = this.createReferenceData(ref);
        } else {
            throw new UnknownTypeException((Object)field);
        }
        data.addField(field.getId(), fieldData);
    }

    private Data createReferenceData(ObjectAdapter ref) {
        if (ref == null) {
            return null;
        }
        Oid refOid = ref.getOid();
        if (refOid == null) {
            return this.createStandaloneData(ref);
        }
        if ((ref.getSpecification().isAggregated() || refOid.isTransient()) && !this.transientObjects.contains(refOid)) {
            this.transientObjects.add(refOid);
            return this.createObjectData(ref);
        }
        String resolvedState = ref.getResolveState().name();
        String specification = ref.getSpecification().getFullIdentifier();
        return new Data(refOid, resolvedState, specification);
    }

    private Data createStandaloneData(ObjectAdapter adapter) {
        return new StandaloneData(adapter);
    }

    protected Data getData() {
        return this.state;
    }

    public Oid getOid() {
        return this.state.getOid();
    }

    public ObjectAdapter recreateObject() {
        ResolveState targetState;
        ObjectAdapter object;
        if (this.state == null) {
            return null;
        }
        ObjectSpecification spec = Memento.getSpecificationLoader().loadSpecification(this.state.getClassName());
        if (this.getOid().isTransient()) {
            object = Memento.getHydrator().recreateAdapter(this.getOid(), spec);
            targetState = ResolveState.SERIALIZING_TRANSIENT;
        } else {
            object = Memento.getHydrator().recreateAdapter(this.getOid(), spec);
            targetState = ResolveState.UPDATING;
        }
        if (object.getSpecification().isCollection()) {
            this.populateCollection(object, (CollectionData)this.state, targetState);
        } else {
            this.updateObject(object, this.state, targetState);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("recreated object " + object.getOid()));
        }
        return object;
    }

    private void populateCollection(ObjectAdapter collection, CollectionData state, ResolveState targetState) {
        ObjectAdapter[] initData = new ObjectAdapter[state.elements.length];
        int i = 0;
        for (Data elementData : state.elements) {
            initData[i++] = this.recreateReference(elementData);
        }
        CollectionFacet facet = (CollectionFacet)collection.getSpecification().getFacet(CollectionFacet.class);
        facet.init(collection, initData);
    }

    private ObjectAdapter recreateReference(Data data) {
        ObjectSpecification spec = Memento.getSpecificationLoader().loadSpecification(data.getClassName());
        if (data instanceof StandaloneData) {
            StandaloneData standaloneData = (StandaloneData)data;
            return standaloneData.getAdapter();
        }
        Oid oid = data.getOid();
        if (oid == null) {
            return null;
        }
        ObjectAdapter ref = Memento.getHydrator().recreateAdapter(oid, spec);
        if (data instanceof ObjectData && (oid.isTransient() || spec.isAggregated())) {
            ResolveState resolveState;
            ResolveState resolveState2 = resolveState = spec.isAggregated() ? ResolveState.GHOST : ResolveState.TRANSIENT;
            if (ref.getResolveState().isValidToChangeTo(resolveState)) {
                ref.changeState(resolveState);
            }
            this.updateObject(ref, data, resolveState);
        }
        return ref;
    }

    public void updateObject(ObjectAdapter object) {
        this.updateObject(object, this.state, ResolveState.RESOLVING);
    }

    private void updateObject(ObjectAdapter object, Data state, ResolveState resolveState) {
        Oid oid = object.getOid();
        if (oid != null && !oid.equals(state.getOid())) {
            throw new IllegalArgumentException("This memento can only be used to update the ObjectAdapter with the Oid " + state.getOid() + " but is " + oid);
        }
        if (!(state instanceof ObjectData)) {
            throw new IsisException("Expected an ObjectData but got " + state.getClass());
        }
        this.updateObject(object, resolveState, state);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("object updated " + object.getOid()));
        }
    }

    private void updateObject(ObjectAdapter object, ResolveState resolveState, Data state) {
        if (object.getResolveState().isValidToChangeTo(resolveState)) {
            PersistorUtil.start(object, resolveState);
            this.updateFields(object, state);
            PersistorUtil.end(object);
        } else if (object.getResolveState() == ResolveState.TRANSIENT && resolveState == ResolveState.TRANSIENT) {
            this.updateFields(object, state);
        } else if (object.isAggregated()) {
            this.updateFields(object, state);
        } else {
            ObjectData od = (ObjectData)state;
            if (od.containsField()) {
                throw new IsisException("Resolve state (for " + object + ") inconsistent with fact that data exists for fields");
            }
        }
    }

    private void updateFields(ObjectAdapter object, Data state) {
        ObjectData od = (ObjectData)state;
        List fields = object.getSpecification().getAssociations();
        for (ObjectAssociation field : fields) {
            if (field.isNotPersisted()) {
                if (field.isOneToManyAssociation()) continue;
                if (field.containsFacet(PropertyOrCollectionAccessorFacet.class) && !field.containsFacet(PropertySetterFacet.class)) {
                    LOG.debug((Object)("ignoring not-settable field " + field.getName()));
                    continue;
                }
            }
            this.updateField(object, od, field);
        }
    }

    private void updateField(ObjectAdapter object, ObjectData od, ObjectAssociation field) {
        Object fieldData = od.getEntry(field.getId());
        if (field.isOneToManyAssociation()) {
            this.updateOneToManyAssociation(object, (OneToManyAssociation)field, (CollectionData)fieldData);
        } else if (field.getSpecification().containsFacet(EncodableFacet.class)) {
            EncodableFacet facet = (EncodableFacet)field.getSpecification().getFacet(EncodableFacet.class);
            ObjectAdapter value = facet.fromEncodedString((String)fieldData);
            ((OneToOneAssociation)field).initAssociation(object, value);
        } else if (field.isOneToOneAssociation()) {
            this.updateOneToOneAssociation(object, (OneToOneAssociation)field, (Data)fieldData);
        }
    }

    private void updateOneToManyAssociation(ObjectAdapter object, OneToManyAssociation field, CollectionData collectionData) {
        Data[] elements;
        ObjectAdapter collection = field.get(object);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
        ArrayList original = Lists.newArrayList();
        for (ObjectAdapter adapter : facet.iterable(collection)) {
            original.add(adapter);
        }
        for (Data data : elements = collectionData.elements) {
            ObjectAdapter element = this.recreateReference(data);
            if (!facet.contains(collection, element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("  association " + field + " changed, added " + element.getOid()));
                }
                field.addElement(object, element);
                continue;
            }
            field.removeElement(object, element);
        }
        for (ObjectAdapter element : original) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  association " + field + " changed, removed " + element.getOid()));
            }
            field.removeElement(object, element);
        }
    }

    private void updateOneToOneAssociation(ObjectAdapter object, OneToOneAssociation field, Data fieldData) {
        if (fieldData == null) {
            field.initAssociation(object, null);
        } else {
            ObjectAdapter ref = this.recreateReference(fieldData);
            if (field.get(object) != ref) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("  association " + field + " changed to " + ref.getOid()));
                }
                field.initAssociation(object, ref);
            }
        }
    }

    public void encodedData(DataOutputStreamExtended outputImpl) throws IOException {
        outputImpl.writeEncodable((Object)this.state);
    }

    public void restore(DataInputStreamExtended inputImpl) throws IOException {
        this.state = (Data)inputImpl.readEncodable(Data.class);
    }

    public String toString() {
        return "[" + (this.state == null ? null : this.state.getClassName() + "/" + this.state.getOid() + this.state) + "]";
    }

    public void debug(DebugBuilder debug) {
        if (this.state != null) {
            this.state.debug(debug);
        }
    }

    private static SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    private static PersistenceSessionHydrator getHydrator() {
        return Memento.getPersistenceSession();
    }
}

