/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence;

import java.util.List;
import org.apache.isis.applib.query.Query;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.logging.Logger;
import org.apache.isis.runtimes.dflt.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.runtimes.dflt.runtime.persistence.UnsupportedFindException;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.AdapterManager;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.ObjectFactory;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.OidGenerator;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;

public class PersistenceSessionLogger
extends Logger
implements PersistenceSession,
DebuggableWithTitle {
    private final PersistenceSession underlying;

    public PersistenceSessionLogger(PersistenceSession decorated, String level) {
        super(level);
        this.underlying = decorated;
    }

    public PersistenceSessionLogger(PersistenceSession decorated) {
        this.underlying = decorated;
    }

    @Override
    public void destroyObject(ObjectAdapter object) {
        this.log("destroy " + object.getObject());
        this.underlying.destroyObject(object);
    }

    public ObjectAdapter findInstances(Query query, QueryCardinality cardinality) throws UnsupportedFindException {
        this.log("find instances matching " + query.getDescription());
        return this.underlying.findInstances(query, cardinality);
    }

    @Override
    public ObjectAdapter findInstances(PersistenceQuery criteria) {
        this.log("find instances matching " + criteria.getSpecification());
        return this.underlying.findInstances(criteria);
    }

    public void debugData(DebugBuilder debug) {
        this.underlying.debugData(debug);
    }

    public String debugTitle() {
        return this.underlying.debugTitle();
    }

    protected Class<?> getDecoratedClass() {
        return this.underlying.getClass();
    }

    @Override
    public ObjectAdapter loadObject(Oid oid, ObjectSpecification hint) throws ObjectNotFoundException {
        ObjectAdapter object = this.underlying.loadObject(oid, hint);
        this.log("get object for " + oid + " (of type " + hint.getShortIdentifier() + ")", object.getObject());
        return object;
    }

    @Override
    public boolean hasInstances(ObjectSpecification specification) {
        boolean hasInstances = this.underlying.hasInstances(specification);
        this.log("has instances of " + specification.getShortIdentifier(), "" + hasInstances);
        return hasInstances;
    }

    @Override
    public boolean isFixturesInstalled() {
        boolean isInitialized = this.underlying.isFixturesInstalled();
        this.log("is initialized: " + isInitialized);
        return isInitialized;
    }

    @Override
    public void open() {
        this.log("opening " + this.underlying);
        this.underlying.open();
    }

    @Override
    public void close() {
        this.log("closing " + this.underlying);
        this.underlying.close();
    }

    @Override
    public void makePersistent(ObjectAdapter object) {
        this.log("make object graph persistent: " + object);
        this.underlying.makePersistent(object);
    }

    @Override
    public void objectChanged(ObjectAdapter object) {
        this.log("notify of change " + object);
        this.underlying.objectChanged(object);
    }

    @Override
    public void reload(ObjectAdapter object) {
        this.underlying.reload(object);
        this.log("reload: " + object);
    }

    @Override
    public void testReset() {
        this.log("reset object manager");
        this.underlying.testReset();
    }

    @Override
    public void resolveImmediately(ObjectAdapter object) {
        this.underlying.resolveImmediately(object);
        this.log("resolve immediately: " + object);
    }

    @Override
    public void resolveField(ObjectAdapter object, ObjectAssociation field) {
        this.log("resolve eagerly (object in a field) " + field + " of " + object);
        this.underlying.resolveField(object, field);
    }

    @Override
    public void objectChangedAllDirty() {
        this.log("saving changes");
        this.underlying.objectChangedAllDirty();
    }

    @Override
    public ObjectAdapter getService(String id) {
        this.log("get service " + id);
        return this.underlying.getService(id);
    }

    @Override
    public List<ObjectAdapter> getServices() {
        this.log("get services ");
        return this.underlying.getServices();
    }

    @Override
    public ObjectAdapter createInstance(ObjectSpecification specification) {
        this.log("create instance " + specification);
        return this.underlying.createInstance(specification);
    }

    @Override
    public ObjectAdapter createAggregatedInstance(ObjectSpecification specification, ObjectAdapter parent) {
        this.log("create aggregated instance " + specification + " as part of " + parent);
        return this.underlying.createAggregatedInstance(specification, parent);
    }

    @Override
    public ObjectAdapter recreateAdapter(Oid oid, ObjectSpecification specification) {
        this.log("recreate instance " + oid + " " + specification);
        return this.underlying.recreateAdapter(oid, specification);
    }

    @Override
    public void setSpecificationLoader(SpecificationLoader specificationLoader) {
        this.underlying.setSpecificationLoader(specificationLoader);
    }

    @Override
    public OidGenerator getOidGenerator() {
        return this.underlying.getOidGenerator();
    }

    @Override
    public ObjectAdapterFactory getAdapterFactory() {
        return this.underlying.getAdapterFactory();
    }

    @Override
    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.underlying.getPersistenceSessionFactory();
    }

    @Override
    public ServicesInjector getServicesInjector() {
        return this.underlying.getServicesInjector();
    }

    @Override
    public IsisTransactionManager getTransactionManager() {
        return this.underlying.getTransactionManager();
    }

    @Override
    public void setTransactionManager(IsisTransactionManager transactionManager) {
        this.underlying.setTransactionManager(transactionManager);
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.underlying.getObjectFactory();
    }

    @Override
    public void clearAllDirty() {
        this.underlying.clearAllDirty();
    }

    @Override
    public ObjectAdapter reload(Oid oid) {
        return this.underlying.reload(oid);
    }

    @Override
    public AdapterManager getAdapterManager() {
        return this.underlying.getAdapterManager();
    }

    @Override
    public ObjectAdapter recreateAdapter(Oid oid, Object pojo) {
        return this.underlying.recreateAdapter(oid, pojo);
    }

    public void injectInto(Object candidate) {
        this.underlying.injectInto(candidate);
    }
}

