/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.adapterfactory.pojo;

import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ElementSpecificationProvider;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.InstanceAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.Specification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.runtimes.dflt.runtime.persistence.ConcurrencyException;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.AdapterManager;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class PojoAdapter
extends InstanceAbstract
implements ObjectAdapter {
    private static final Logger LOG = Logger.getLogger(PojoAdapter.class);
    private static final int INCOMPLETE_COLLECTION = -1;
    private Object pojo;
    private transient ResolveState resolveState;
    private Oid oid;
    private Version version;
    private String defaultTitle;
    private ElementSpecificationProvider elementSpecificationProvider;

    public PojoAdapter(Object pojo, Oid oid) {
        if (pojo instanceof ObjectAdapter) {
            throw new IsisException("Adapter can't be used to adapt an adapter: " + pojo);
        }
        this.pojo = pojo;
        this.oid = oid;
        this.resolveState = ResolveState.NEW;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (LOG.isDebugEnabled()) {
            // empty if block
        }
    }

    protected ObjectSpecification loadSpecification() {
        ObjectSpecification specification = this.getReflector().loadSpecification(this.getObject().getClass());
        this.defaultTitle = "A" + (" " + specification.getSingularName()).toLowerCase();
        return specification;
    }

    public final ObjectSpecification getSpecification() {
        ObjectSpecification specification = (ObjectSpecification)super.getSpecification();
        return specification;
    }

    public Object getObject() {
        return this.pojo;
    }

    public void replacePojo(Object pojo) {
        this.pojo = pojo;
    }

    public ResolveState getResolveState() {
        return this.resolveState;
    }

    public void changeState(ResolveState newState) {
        boolean validToChangeTo = this.resolveState.isValidToChangeTo(newState);
        Assert.assertTrue((String)("oid= " + this.getOid() + "; can't change from " + this.resolveState.name() + " to " + newState.name()), (boolean)validToChangeTo);
        if (LOG.isTraceEnabled()) {
            String oidString = this.oid == null ? "" : "for " + this.getOid() + " ";
            LOG.trace((Object)(oidString + "changing resolved state to " + newState.name()));
        }
        this.resolveState = newState;
    }

    private boolean elementsLoaded() {
        return this.isTransient() || this.getResolveState().isResolved();
    }

    public boolean isPersistent() {
        return this.getResolveState().isPersistent();
    }

    public boolean isTransient() {
        return this.getResolveState().isTransient();
    }

    public Oid getOid() {
        return this.oid;
    }

    protected void setOid(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.oid = oid;
    }

    public boolean isAggregated() {
        return this.getOid() instanceof AggregatedOid;
    }

    public ObjectAdapter getAggregateRoot() {
        if (this.getSpecification().isAggregated()) {
            Oid parentOid = ((AggregatedOid)this.getOid()).getParentOid();
            return this.getAdapterManager().getAdapterFor(parentOid);
        }
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    public void checkLock(Version version) {
        if (this.version != null && this.version.different(version)) {
            LOG.info((Object)("concurrency conflict on " + (Object)((Object)this) + " (" + version + ")"));
            throw new ConcurrencyException(this, version);
        }
    }

    public void setOptimisticLock(Version version) {
        if (this.shouldSetVersion(version)) {
            this.version = version;
        }
    }

    private boolean shouldSetVersion(Version version) {
        return this.version == null || version == null || version.different(this.version);
    }

    public String titleString() {
        if (this.getSpecification().isCollection()) {
            CollectionFacet facet = (CollectionFacet)this.getSpecification().getFacet(CollectionFacet.class);
            return this.collectionTitleString(facet);
        }
        return this.objectTitleString();
    }

    private String objectTitleString() {
        Localization localization;
        ResolveState resolveState = this.getResolveState();
        if (resolveState.isNew()) {
            return "";
        }
        if (this.getObject() instanceof String) {
            return (String)this.getObject();
        }
        ObjectSpecification specification = this.getSpecification();
        String title = specification.getTitle((ObjectAdapter)this, localization = this.getLocalization());
        if (title == null && resolveState.isGhost()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("attempting to use unresolved object; resolving it immediately: oid=" + this.getOid()));
            }
            this.getObjectPersistor().resolveImmediately(this);
        }
        if (title == null) {
            title = this.getDefaultTitle();
        }
        return title;
    }

    private String collectionTitleString(CollectionFacet facet) {
        int size = this.elementsLoaded() ? facet.size((ObjectAdapter)this) : -1;
        ObjectSpecification elementSpecification = this.getElementSpecification();
        if (elementSpecification == null || elementSpecification.getFullIdentifier().equals(Object.class.getName())) {
            switch (size) {
                case -1: {
                    return "Objects";
                }
                case 0: {
                    return "No objects";
                }
                case 1: {
                    return "1 object";
                }
            }
            return size + " objects";
        }
        switch (size) {
            case -1: {
                return elementSpecification.getPluralName();
            }
            case 0: {
                return "No " + elementSpecification.getPluralName();
            }
            case 1: {
                return "1 " + elementSpecification.getSingularName();
            }
        }
        return size + " " + elementSpecification.getPluralName();
    }

    public synchronized String toString() {
        ToString str = new ToString((Object)this);
        this.toString(str);
        str.append("pojo-toString", this.pojo.toString());
        str.appendAsHex("pojo-hash", (long)this.pojo.hashCode());
        return str.toString();
    }

    protected String getDefaultTitle() {
        return this.defaultTitle;
    }

    protected void toString(ToString str) {
        str.append(this.resolveState.code());
        Oid oid = this.getOid();
        if (oid != null) {
            str.append(":");
            str.append(oid.toString());
        } else {
            str.append(":-");
        }
        str.setAddComma();
        if (this.getSpecificationNoLoad() == null) {
            str.append("class", this.getObject().getClass().getName());
        } else {
            str.append("specification", this.getSpecification().getShortIdentifier());
        }
        str.append("version", this.version == null ? null : this.version.sequence());
    }

    public String getIconName() {
        return this.getSpecification().getIconName((ObjectAdapter)this);
    }

    public ObjectSpecification getElementSpecification() {
        if (this.elementSpecificationProvider == null) {
            return null;
        }
        return this.elementSpecificationProvider.getElementType();
    }

    public void setElementSpecificationProvider(ElementSpecificationProvider elementSpecificationProvider) {
        this.elementSpecificationProvider = elementSpecificationProvider;
    }

    public Instance getInstance(Specification specification) {
        throw new UnsupportedOperationException();
    }

    public void fireChangedEvent() {
    }

    protected Localization getLocalization() {
        return IsisContext.getLocalization();
    }

    private SpecificationLoader getReflector() {
        return IsisContext.getSpecificationLoader();
    }

    private PersistenceSession getObjectPersistor() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

