/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager;

import java.util.Iterator;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.oid.AggregatedOid;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.object.aggregated.AggregatedFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.typeof.ElementSpecificationProviderFromTypeOfFacet;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderAware;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.runtimes.dflt.runtime.persistence.adapterfactory.AdapterFactoryAware;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.AdapterManagerAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.AggregateAdapters;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal.OidAdapterHashMap;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal.OidAdapterMap;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal.PojoAdapterHashMap;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal.PojoAdapterMap;
import org.apache.isis.runtimes.dflt.runtime.persistence.oidgenerator.OidGeneratorAware;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.OidGenerator;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class AdapterManagerDefault
extends AdapterManagerAbstract
implements AdapterFactoryAware,
SpecificationLoaderAware,
OidGeneratorAware,
ServicesInjectorAware,
DebuggableWithTitle {
    private static final Logger LOG = Logger.getLogger(AdapterManagerDefault.class);
    protected PojoAdapterMap pojoAdapterMap;
    protected OidAdapterMap oidAdapterMap;
    private ObjectAdapterFactory adapterFactory;
    private SpecificationLoader specificationLoader;
    private OidGenerator oidGenerator;
    private ServicesInjector servicesInjector;

    public void open() {
        Ensure.ensureThatState((Object)this.adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)this.specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)this.oidGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)this.servicesInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        if (this.oidAdapterMap == null) {
            this.oidAdapterMap = new OidAdapterHashMap();
        }
        if (this.pojoAdapterMap == null) {
            this.pojoAdapterMap = new PojoAdapterHashMap();
        }
        this.oidAdapterMap.open();
        this.pojoAdapterMap.open();
    }

    public void close() {
        this.oidAdapterMap.close();
        this.pojoAdapterMap.close();
    }

    public void reset() {
        this.oidAdapterMap.reset();
        this.pojoAdapterMap.reset();
    }

    @Override
    public Iterator<ObjectAdapter> iterator() {
        return this.getPojoAdapterMap().iterator();
    }

    @Override
    public ObjectAdapter addExistingAdapter(ObjectAdapter adapter) {
        this.mapAndInjectServices(adapter);
        return adapter;
    }

    public ObjectAdapter getAdapterFor(Object pojo) {
        Ensure.ensureThatArg((Object)pojo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return this.getPojoAdapterMap().getAdapter(pojo);
    }

    public ObjectAdapter getAdapterFor(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.ensureMapsConsistent(oid);
        return this.getOidAdapterMap().getAdapter(oid);
    }

    public ObjectAdapter adapterFor(Object pojo) {
        ObjectAdapter adapter = this.getAdapterFor(pojo);
        if (adapter != null) {
            return adapter;
        }
        ObjectSpecification noSpec = this.getSpecificationLoader().loadSpecification(pojo.getClass());
        if (noSpec.containsFacet(ValueFacet.class)) {
            return this.createStandaloneAdapter(pojo);
        }
        return this.map(this.createOrRecreateRootAdapter(pojo));
    }

    public ObjectAdapter adapterForAggregated(Object pojo, ObjectAdapter parent) {
        ObjectAdapter adapter = this.getAdapterFor(pojo);
        if (adapter != null) {
            return adapter;
        }
        String id = this.getOidGenerator().createAggregateId(pojo);
        AggregatedOid aggregatedOid = new AggregatedOid(parent.getOid(), id);
        AggregateAdapters aggregatedAdapter = this.createOrRecreateRootAdapter(pojo, (Oid)aggregatedOid);
        return this.map(aggregatedAdapter);
    }

    public ObjectAdapter adapterFor(Object pojo, ObjectAdapter ownerAdapter, IdentifiedHolder identifiedHolder) {
        ObjectAdapter adapter = this.getAdapterFor(pojo);
        if (adapter != null) {
            return adapter;
        }
        ObjectSpecification noSpec = this.getSpecificationLoader().loadSpecification(pojo.getClass());
        if (noSpec.containsFacet(ValueFacet.class)) {
            return this.createStandaloneAdapter(pojo);
        }
        if (ownerAdapter != null && identifiedHolder != null && (this.specIsAggregated(noSpec) || this.referenceIsAggregated(identifiedHolder))) {
            ObjectAdapter newAdapter = this.createAggregatedAdapter(pojo, ownerAdapter, identifiedHolder);
            return this.mapAndInjectServices(newAdapter);
        }
        return this.map(this.createOrRecreateRootAdapter(pojo));
    }

    private boolean specIsAggregated(ObjectSpecification noSpec) {
        return noSpec.containsFacet(AggregatedFacet.class);
    }

    private boolean referenceIsAggregated(IdentifiedHolder identifiedHolder) {
        return identifiedHolder.containsFacet(AggregatedFacet.class);
    }

    @Override
    public ObjectAdapter recreateRootAdapter(Oid oid, Object pojo) {
        ObjectAdapter adapterLookedUpByPojo = this.getAdapterFor(pojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        ObjectAdapter adapterLookedUpByOid = this.getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        return this.map(this.createOrRecreateRootAdapter(pojo, oid));
    }

    @Override
    public void remapUpdated(Oid oid) {
        ObjectAdapter lookedUpAdapter;
        Ensure.ensureThatArg((Object)oid.hasPrevious(), (Matcher)CoreMatchers.is((Object)true));
        Oid previousOid = oid.getPrevious();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remapping oid: " + oid + " with previous oid of: " + previousOid));
        }
        if ((lookedUpAdapter = this.oidAdapterMap.getAdapter(previousOid)) == null) {
            LOG.warn((Object)("could not locate previousOid: " + previousOid));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing previous oid" + previousOid));
        }
        this.oidAdapterMap.remove(previousOid);
        Oid lookedUpAdapterOid = lookedUpAdapter.getOid();
        lookedUpAdapterOid.copyFrom(oid);
        this.oidAdapterMap.add(lookedUpAdapterOid, lookedUpAdapter);
    }

    @Override
    public void removeAdapter(ObjectAdapter adapter) {
        this.ensureMapsConsistent(adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing adapter: " + adapter));
        }
        this.unmap(adapter);
    }

    @Override
    public void remapAsPersistent(ObjectAdapter adapter) {
        AggregateAdapters aggregateAdapters = this.aggregateAdaptersFor(adapter);
        this.remapAsPersistent(aggregateAdapters);
    }

    private AggregateAdapters aggregateAdaptersFor(ObjectAdapter rootAdapter) {
        AggregateAdapters aggregateAdapters = new AggregateAdapters(rootAdapter);
        Oid rootOid = rootAdapter.getOid();
        for (OneToManyAssociation otma : rootAdapter.getSpecification().getCollections()) {
            AggregatedOid aggregatedOid = new AggregatedOid(rootOid, otma.getName());
            ObjectAdapter collectionAdapter = this.getAdapterFor((Oid)aggregatedOid);
            if (collectionAdapter == null) continue;
            aggregateAdapters.addCollectionAdapter(otma, collectionAdapter);
        }
        return aggregateAdapters;
    }

    private void remapAsPersistent(AggregateAdapters aggregateAdapters) {
        boolean removed;
        ObjectAdapter rootAdapter = aggregateAdapters.getRootAdapter();
        Oid oid = rootAdapter.getOid();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remapAsPersistent: " + oid));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"removing root adapter from oid map");
        }
        if (!(removed = this.getOidAdapterMap().remove(oid))) {
            LOG.warn((Object)("could not remove oid: " + oid));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"removing collection adapter(s) from oid map");
        }
        for (ObjectAdapter collectionAdapter : aggregateAdapters) {
            Oid collectionOid = collectionAdapter.getOid();
            removed = this.getOidAdapterMap().remove(collectionOid);
            if (removed) continue;
            LOG.warn((Object)("could not remove collectionOid: " + collectionOid));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"updating the Oid");
        }
        this.getOidGenerator().convertTransientToPersistentOid(oid);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("re-adding into maps; oid is now: " + oid));
        }
        this.getOidAdapterMap().add(oid, rootAdapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"re-adding collection adapter(s) to oid map");
        }
        for (ObjectAdapter collectionAdapter : aggregateAdapters) {
            AggregatedOid previousCollectionOid = (AggregatedOid)collectionAdapter.getOid();
            this.getOidAdapterMap().add((Oid)previousCollectionOid, collectionAdapter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"replacing any collection pojos, remapping in pojo map");
        }
        for (OneToManyAssociation otma : aggregateAdapters.getCollections()) {
            ObjectAdapter collectionAdapter = aggregateAdapters.getCollectionAdapter(otma);
            Object collectionPojoWrappedByAdapter = collectionAdapter.getObject();
            Object collectionPojoOnRootPojo = this.getCollectionPojo(otma, rootAdapter);
            if (collectionPojoOnRootPojo == collectionPojoWrappedByAdapter) continue;
            this.getPojoAdapterMap().remove(collectionAdapter);
            collectionAdapter.replacePojo(collectionPojoOnRootPojo);
            this.getPojoAdapterMap().add(collectionPojoOnRootPojo, collectionAdapter);
        }
        rootAdapter.changeState(ResolveState.RESOLVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("made persistent " + rootAdapter + "; was " + oid.getPrevious()));
        }
    }

    public Object getCollectionPojo(OneToManyAssociation association, ObjectAdapter ownerAdapter) {
        PropertyOrCollectionAccessorFacet accessor = (PropertyOrCollectionAccessorFacet)association.getFacet(PropertyOrCollectionAccessorFacet.class);
        return accessor.getProperty(ownerAdapter);
    }

    @Override
    public ObjectAdapter testCreateTransient(Object pojo, Oid oid) {
        if (!oid.isTransient()) {
            throw new IllegalArgumentException("Oid should be transient; use standard API to recreate adapters for persistent Oids");
        }
        return this.map(this.createOrRecreateRootAdapter(pojo, oid));
    }

    protected AggregateAdapters createOrRecreateRootAdapter(Object pojo) {
        Oid transientOid = this.createOid(pojo);
        return this.createOrRecreateRootAdapter(pojo, transientOid);
    }

    protected Oid createOid(Object pojo) {
        return this.getOidGenerator().createTransientOid(pojo);
    }

    protected ObjectAdapter createAggregatedAdapter(Object pojo, ObjectAdapter ownerAdapter, IdentifiedHolder identifiedHolder) {
        Identifier identifier = identifiedHolder.getIdentifier();
        this.ensureMapsConsistent(ownerAdapter);
        Assert.assertNotNull((Object)pojo);
        if (!(identifiedHolder instanceof OneToManyAssociation)) {
            throw new IsisException("only applicable to collections " + pojo + " in " + identifiedHolder);
        }
        AggregatedOid aggregatedOid = new AggregatedOid(ownerAdapter.getOid(), identifier.getMemberName());
        ObjectAdapter aggregatedAdapter = this.createOrRecreateAdapter(pojo, (Oid)aggregatedOid);
        TypeOfFacet facet = (TypeOfFacet)identifiedHolder.getFacet(TypeOfFacet.class);
        aggregatedAdapter.setElementSpecificationProvider(ElementSpecificationProviderFromTypeOfFacet.createFrom((TypeOfFacet)facet));
        aggregatedAdapter.setOptimisticLock(ownerAdapter.getVersion());
        return aggregatedAdapter;
    }

    private ObjectAdapter createStandaloneAdapter(Object pojo) {
        return this.createOrRecreateAdapter(pojo, null);
    }

    private AggregateAdapters createOrRecreateRootAdapter(Object pojo, Oid oid) {
        ObjectAdapter rootAdapter = this.createOrRecreateAdapter(pojo, oid);
        AggregateAdapters aggregateAdapters = new AggregateAdapters(rootAdapter);
        return aggregateAdapters;
    }

    private void eagerlyCreateCollectionAdapters(ObjectAdapter rootAdapter, AggregateAdapters aggregateAdapters) {
        for (OneToManyAssociation otma : rootAdapter.getSpecification().getCollections()) {
            Object referencedCollection = this.getCollectionPojo(otma, rootAdapter);
            ObjectAdapter collectionAdapter = this.createAggregatedAdapter(referencedCollection, rootAdapter, (IdentifiedHolder)otma);
            aggregateAdapters.addCollectionAdapter(otma, collectionAdapter);
        }
    }

    private ObjectAdapter createOrRecreateAdapter(Object pojo, Oid oid) {
        ObjectAdapter adapter = this.getAdapterFactory().createAdapter(pojo, oid);
        if (oid == null) {
            adapter.changeState(ResolveState.VALUE);
        } else {
            adapter.changeState(oid.isTransient() ? ResolveState.TRANSIENT : ResolveState.GHOST);
        }
        return adapter;
    }

    private ObjectAdapter map(AggregateAdapters aggregateAdapters) {
        Assert.assertNotNull((Object)aggregateAdapters);
        ObjectAdapter adapter = aggregateAdapters.getRootAdapter();
        this.mapAndInjectServices(adapter);
        for (ObjectAdapter collectionAdapter : aggregateAdapters) {
            this.mapAndInjectServices(collectionAdapter);
        }
        return adapter;
    }

    private ObjectAdapter mapAndInjectServices(ObjectAdapter adapter) {
        Assert.assertNotNull((Object)adapter);
        Object pojo = adapter.getObject();
        Assert.assertFalse((String)"POJO Map already contains object", (Object)pojo, (boolean)this.getPojoAdapterMap().containsPojo(pojo));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding identity for adapter with oid=" + adapter.getOid()));
        }
        if (adapter.getResolveState().isValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"not mapping value adapter");
            }
            this.servicesInjector.injectDependencies(pojo);
            return adapter;
        }
        ObjectSpecification noSpec = adapter.getSpecification();
        if (!adapter.isAggregated() || adapter.isAggregated() && !noSpec.isImmutable()) {
            this.getPojoAdapterMap().add(pojo, adapter);
        }
        this.getOidAdapterMap().add(adapter.getOid(), adapter);
        this.servicesInjector.injectDependencies(pojo);
        return adapter;
    }

    private void unmap(ObjectAdapter adapter) {
        this.ensureMapsConsistent(adapter);
        Oid oid = adapter.getOid();
        if (oid != null) {
            this.getOidAdapterMap().remove(oid);
        }
        this.getPojoAdapterMap().remove(adapter);
    }

    private void ensureMapsConsistent(ObjectAdapter adapter) {
        if (adapter.getResolveState().isValue()) {
            return;
        }
        if (adapter.isAggregated()) {
            return;
        }
        this.ensurePojoAdapterMapConsistent(adapter);
        this.ensureOidAdapterMapConsistent(adapter);
    }

    private void ensureMapsConsistent(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectAdapter adapter = this.getOidAdapterMap().getAdapter(oid);
        if (adapter == null) {
            return;
        }
        this.ensureOidAdapterMapConsistent(adapter);
        this.ensurePojoAdapterMapConsistent(adapter);
    }

    private void ensurePojoAdapterMapConsistent(ObjectAdapter adapter) {
        Object adapterPojo = adapter.getObject();
        ObjectAdapter adapterAccordingToPojoAdapterMap = this.getPojoAdapterMap().getAdapter(adapterPojo);
        Ensure.ensureThatArg((Object)adapter, (Matcher)CoreMatchers.is((Object)adapterAccordingToPojoAdapterMap), (String)("mismatch in PojoAdapterMap: adapter's Pojo: " + adapterPojo + ", \n" + "provided adapter: " + adapter + "; \n" + " but map's adapter was : " + adapterAccordingToPojoAdapterMap));
    }

    private void ensureOidAdapterMapConsistent(ObjectAdapter adapter) {
        Oid adapterOid = adapter.getOid();
        ObjectAdapter adapterAccordingToOidAdapterMap = this.getOidAdapterMap().getAdapter(adapterOid);
        Ensure.ensureThatArg((Object)adapter, (Matcher)CoreMatchers.is((Object)adapterAccordingToOidAdapterMap), (String)("mismatch in OidAdapter map: adapter's Oid: " + adapterOid + ", " + "provided adapter: " + adapter + "; " + "map's adapter: " + adapterAccordingToOidAdapterMap));
    }

    public String debugTitle() {
        return "Identity map (adapter manager)";
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle(this.pojoAdapterMap.debugTitle());
        this.pojoAdapterMap.debugData(debug);
        debug.appendln();
        debug.appendTitle(this.oidAdapterMap.debugTitle());
        this.oidAdapterMap.debugData(debug);
    }

    private OidAdapterMap getOidAdapterMap() {
        return this.oidAdapterMap;
    }

    public void setOidAdapterMap(OidAdapterMap identityAdapterMap) {
        this.oidAdapterMap = identityAdapterMap;
    }

    private PojoAdapterMap getPojoAdapterMap() {
        return this.pojoAdapterMap;
    }

    public void setPojoAdapterMap(PojoAdapterMap pojoAdapterMap) {
        this.pojoAdapterMap = pojoAdapterMap;
    }

    public ObjectAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public void setAdapterFactory(ObjectAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    public void setSpecificationLoader(SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
    }

    public OidGenerator getOidGenerator() {
        return this.oidGenerator;
    }

    @Override
    public void setOidGenerator(OidGenerator oidGenerator) {
        this.oidGenerator = oidGenerator;
    }

    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

