/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager;

import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.AdapterManager;

public final class AdapterUtils {
    private AdapterUtils() {
    }

    public static ObjectAdapter createAdapter(Class<?> type, Object object, AdapterManager adapterManager, SpecificationLoader specificationLoader) {
        ObjectSpecification specification = specificationLoader.loadSpecification(type);
        if (specification.isNotCollection()) {
            return adapterManager.adapterFor(object);
        }
        throw new UnknownTypeException("not an object, is this a collection?");
    }

    public static Object[] getCollectionAsObjectArray(Object option, ObjectSpecification spec, AdapterManager adapterManager) {
        ObjectAdapter collection = adapterManager.adapterFor(option);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
        Object[] optionArray = new Object[facet.size(collection)];
        int j = 0;
        for (ObjectAdapter adapter : facet.iterable(collection)) {
            optionArray[j++] = adapter.getObject();
        }
        return optionArray;
    }

    public static Object domainObject(ObjectAdapter inObject) {
        return inObject == null ? null : inObject.getObject();
    }
}

