/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public class AggregateAdapters
implements Iterable<ObjectAdapter> {
    private final ObjectAdapter rootAdapter;
    private final Map<OneToManyAssociation, ObjectAdapter> collectionAdapters = new LinkedHashMap<OneToManyAssociation, ObjectAdapter>();

    public AggregateAdapters(ObjectAdapter rootAdapter) {
        Assert.assertNotNull((Object)rootAdapter);
        this.rootAdapter = rootAdapter;
    }

    public ObjectAdapter getRootAdapter() {
        return this.rootAdapter;
    }

    public void addCollectionAdapter(OneToManyAssociation otma, ObjectAdapter collectionAdapter) {
        Assert.assertNotNull((Object)otma);
        Assert.assertNotNull((Object)collectionAdapter);
        this.collectionAdapters.put(otma, collectionAdapter);
    }

    public Map<OneToManyAssociation, ObjectAdapter> getCollectionAdapters() {
        return Collections.unmodifiableMap(this.collectionAdapters);
    }

    @Override
    public Iterator<ObjectAdapter> iterator() {
        return this.getCollectionAdapters().values().iterator();
    }

    public Set<OneToManyAssociation> getCollections() {
        return this.getCollectionAdapters().keySet();
    }

    public ObjectAdapter getCollectionAdapter(OneToManyAssociation otma) {
        return this.collectionAdapters.get(otma);
    }
}

