/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal.OidAdapterMap;
import org.apache.log4j.Logger;

public class OidAdapterHashMap
implements OidAdapterMap {
    private static final Logger LOG = Logger.getLogger(OidAdapterHashMap.class);
    private static final int DEFAULT_OID_ADAPTER_MAP_SIZE = 10;
    private final Hashtable<Oid, ObjectAdapter> adapterByOidMap;

    public OidAdapterHashMap() {
        this(10);
    }

    public OidAdapterHashMap(int capacity) {
        this.adapterByOidMap = new Hashtable(capacity);
    }

    public void open() {
    }

    public void close() {
        LOG.debug((Object)"close");
        this.adapterByOidMap.clear();
    }

    public void reset() {
        LOG.debug((Object)"reset");
        Iterator<Map.Entry<Oid, ObjectAdapter>> iterator = this.adapterByOidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Oid, ObjectAdapter> entry = iterator.next();
            ObjectAdapter adapter = entry.getValue();
            if (adapter.getSpecification().isService()) continue;
            iterator.remove();
        }
    }

    @Override
    public void add(Oid oid, ObjectAdapter adapter) {
        this.adapterByOidMap.put(oid, adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("add oid: " + oid + " ; oid.hashCode: + #" + Long.toHexString(oid.hashCode()) + " ; adapter.hashCode(): #" + Long.toHexString(adapter.hashCode())));
        }
    }

    @Override
    public boolean remove(Oid oid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remove oid: " + oid));
        }
        return this.adapterByOidMap.remove(oid) != null;
    }

    @Override
    public ObjectAdapter getAdapter(Oid oid) {
        return this.adapterByOidMap.get(oid);
    }

    @Override
    public Iterator<Oid> iterator() {
        return this.adapterByOidMap.keySet().iterator();
    }

    public String debugTitle() {
        return "Identity adapter map";
    }

    public void debugData(DebugBuilder debug) {
        int count = 1;
        for (Oid oid : this) {
            ObjectAdapter adapter = this.getAdapter(oid);
            debug.append(count++, 5);
            debug.append((Object)" '");
            debug.append((Object)oid.toString(), 15);
            debug.append((Object)"'    ");
            debug.appendln(adapter != null ? adapter.toString() : "(MISSING OBJECT ?!)");
        }
    }
}

