/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.internal.PojoAdapterMap;
import org.apache.log4j.Logger;

public class PojoAdapterHashMap
implements PojoAdapterMap {
    private static final Logger LOG = Logger.getLogger(PojoAdapterHashMap.class);
    public static final int DEFAULT_POJO_ADAPTER_MAP_SIZE = 10;
    protected final Map<Object, ObjectAdapter> adapterByPojoMap;

    public PojoAdapterHashMap() {
        this(10);
    }

    public PojoAdapterHashMap(int capacity) {
        this.adapterByPojoMap = new HashMap<Object, ObjectAdapter>(capacity);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug((Object)"finalizing hash of pojos");
    }

    public void open() {
    }

    public void close() {
        LOG.debug((Object)"close");
        this.adapterByPojoMap.clear();
    }

    public void reset() {
        LOG.debug((Object)"reset");
        Iterator<Map.Entry<Object, ObjectAdapter>> iterator = this.adapterByPojoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, ObjectAdapter> entry = iterator.next();
            ObjectAdapter adapter = entry.getValue();
            if (adapter.getSpecification().isService()) continue;
            iterator.remove();
        }
    }

    @Override
    public void add(Object pojo, ObjectAdapter adapter) {
        this.adapterByPojoMap.put(this.key(pojo), adapter);
        LOG.debug((Object)("add adapter: #" + Long.toHexString(pojo.hashCode()) + " -> #" + Long.toHexString(adapter.hashCode())));
        if (adapter.getResolveState().isResolved() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("add " + new ToString(pojo) + " as " + adapter));
        }
    }

    @Override
    public void remove(ObjectAdapter object) {
        LOG.debug((Object)("remove adapater: " + object));
        this.adapterByPojoMap.remove(this.key(object.getObject()));
    }

    @Override
    public boolean containsPojo(Object pojo) {
        return this.adapterByPojoMap.containsKey(this.key(pojo));
    }

    @Override
    public ObjectAdapter getAdapter(Object pojo) {
        return this.adapterByPojoMap.get(this.key(pojo));
    }

    @Override
    public Iterator<ObjectAdapter> iterator() {
        return this.adapterByPojoMap.values().iterator();
    }

    private Object key(Object pojo) {
        return new IdentityHashKey(pojo);
    }

    public void debugData(DebugBuilder debug) {
        int count = 0;
        for (Object pojo : this.adapterByPojoMap.keySet()) {
            ObjectAdapter object = this.adapterByPojoMap.get(pojo);
            debug.append(count++ + 1, 5);
            debug.append((Object)" '");
            debug.append((Object)pojo.toString(), 50);
            debug.append((Object)"'    ");
            debug.appendln(object.toString());
        }
    }

    public String debugTitle() {
        return "POJO Adapter Hashtable";
    }

    private static class IdentityHashKey {
        private final Object pojo;

        public IdentityHashKey(Object pojo) {
            this.pojo = pojo;
        }

        public int hashCode() {
            return System.identityHashCode(this.pojo);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IdentityHashKey && ((IdentityHashKey)obj).pojo == this.pojo;
        }
    }
}

