/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.internal;

import java.util.List;
import org.apache.isis.applib.ApplicationException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.query.Query;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAbstract;
import org.apache.isis.core.metamodel.adapter.DomainObjectServices;
import org.apache.isis.core.metamodel.adapter.DomainObjectServicesAbstract;
import org.apache.isis.core.metamodel.adapter.LocalizationProviderAbstract;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.ObjectDirtierAbstract;
import org.apache.isis.core.metamodel.adapter.ObjectPersistor;
import org.apache.isis.core.metamodel.adapter.ObjectPersistorAbstract;
import org.apache.isis.core.metamodel.adapter.QuerySubmitter;
import org.apache.isis.core.metamodel.adapter.QuerySubmitterAbstract;
import org.apache.isis.core.metamodel.adapter.ServicesProvider;
import org.apache.isis.core.metamodel.adapter.ServicesProviderAbstract;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAbstract;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjector;
import org.apache.isis.core.metamodel.runtimecontext.DependencyInjectorAbstract;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAbstract;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectInstantiationException;
import org.apache.isis.core.metamodel.spec.ObjectInstantiator;
import org.apache.isis.core.metamodel.spec.ObjectInstantiatorAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.runtime.persistence.container.DomainObjectContainerObjectChanged;
import org.apache.isis.runtimes.dflt.runtime.persistence.container.DomainObjectContainerResolve;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.AdapterManager;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.MessageBroker;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.UpdateNotifier;

public class RuntimeContextFromSession
extends RuntimeContextAbstract {
    private final AuthenticationSessionProvider authenticationSessionProvider = new AuthenticationSessionProviderAbstract(){

        public AuthenticationSession getAuthenticationSession() {
            return IsisContext.getAuthenticationSession();
        }
    };
    private final AdapterMap adapterManager = new AdapterMapAbstract(){

        public ObjectAdapter getAdapterFor(Object pojo) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().getAdapterFor(pojo);
        }

        public ObjectAdapter adapterFor(Object pojo) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterFor(pojo);
        }

        public ObjectAdapter adapterForAggregated(Object domainObject, ObjectAdapter parent) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterForAggregated(domainObject, parent);
        }

        public ObjectAdapter adapterFor(Object pojo, ObjectAdapter ownerAdapter, IdentifiedHolder identifiedHolder) {
            return RuntimeContextFromSession.getRuntimeAdapterManager().adapterFor(pojo, ownerAdapter, identifiedHolder);
        }
    };
    private final ObjectDirtier objectDirtier;
    private final ObjectInstantiator objectInstantiator = new ObjectInstantiatorAbstract(){

        public Object instantiate(Class<?> cls) throws ObjectInstantiationException {
            return RuntimeContextFromSession.getPersistenceSession().getObjectFactory().instantiate(cls);
        }
    };
    private final ObjectPersistor objectPersistor;
    private final ServicesProvider servicesProvider;
    private final DependencyInjector dependencyInjector;
    private final QuerySubmitter querySubmitter;
    private final DomainObjectServices domainObjectServices;
    private final LocalizationProviderAbstract localizationProvider;

    public RuntimeContextFromSession() {
        this.objectDirtier = new ObjectDirtierAbstract(){

            public void objectChanged(ObjectAdapter adapter) {
                RuntimeContextFromSession.getPersistenceSession().objectChanged(adapter);
            }

            public void objectChanged(Object object) {
                new DomainObjectContainerObjectChanged().objectChanged(object);
            }
        };
        this.objectPersistor = new ObjectPersistorAbstract(){

            public void makePersistent(ObjectAdapter adapter) {
                RuntimeContextFromSession.getPersistenceSession().makePersistent(adapter);
            }

            public void remove(ObjectAdapter adapter) {
                RuntimeContextFromSession.getUpdateNotifier().addDisposedObject(adapter);
                RuntimeContextFromSession.getPersistenceSession().destroyObject(adapter);
            }
        };
        this.servicesProvider = new ServicesProviderAbstract(){

            public List<ObjectAdapter> getServices() {
                return RuntimeContextFromSession.getPersistenceSession().getServices();
            }
        };
        this.domainObjectServices = new DomainObjectServicesAbstract(){

            public ObjectAdapter createTransientInstance(ObjectSpecification spec) {
                return RuntimeContextFromSession.getPersistenceSession().createInstance(spec);
            }

            public ObjectAdapter createAggregatedInstance(ObjectSpecification spec, ObjectAdapter parent) {
                return RuntimeContextFromSession.getPersistenceSession().createAggregatedInstance(spec, parent);
            }

            public void resolve(Object parent) {
                new DomainObjectContainerResolve().resolve(parent);
            }

            public void resolve(Object parent, Object field) {
                new DomainObjectContainerResolve().resolve(parent, field);
            }

            public boolean flush() {
                return RuntimeContextFromSession.getTransactionManager().flushTransaction();
            }

            public void commit() {
                RuntimeContextFromSession.getTransactionManager().endTransaction();
            }

            public void informUser(String message) {
                RuntimeContextFromSession.getMessageBroker().addMessage(message);
            }

            public void warnUser(String message) {
                RuntimeContextFromSession.getMessageBroker().addWarning(message);
            }

            public void raiseError(String message) {
                throw new ApplicationException(message);
            }

            public String getProperty(String name) {
                return RuntimeContextFromSession.this.getProperty(name);
            }

            public List<String> getPropertyNames() {
                return RuntimeContextFromSession.this.getPropertyNames();
            }
        };
        this.querySubmitter = new QuerySubmitterAbstract(){

            public <T> List<ObjectAdapter> allMatchingQuery(Query<T> query) {
                ObjectAdapter instances = RuntimeContextFromSession.getPersistenceSession().findInstances(query, QueryCardinality.MULTIPLE);
                return CollectionFacetUtils.convertToAdapterList((ObjectAdapter)instances);
            }

            public <T> ObjectAdapter firstMatchingQuery(Query<T> query) {
                ObjectAdapter instances = RuntimeContextFromSession.getPersistenceSession().findInstances(query, QueryCardinality.SINGLE);
                List list = CollectionFacetUtils.convertToAdapterList((ObjectAdapter)instances);
                return list.size() > 0 ? (ObjectAdapter)list.get(0) : null;
            }
        };
        this.dependencyInjector = new DependencyInjectorAbstract(){

            public void injectDependenciesInto(Object object) {
                RuntimeContextFromSession.getPersistenceSession().getServicesInjector().injectDependencies(object);
            }
        };
        this.localizationProvider = new LocalizationProviderAbstract(){

            public Localization getLocalization() {
                return IsisContext.getLocalization();
            }
        };
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    public AdapterMap getAdapterMap() {
        return this.adapterManager;
    }

    public ObjectInstantiator getObjectInstantiator() {
        return this.objectInstantiator;
    }

    public DomainObjectServices getDomainObjectServices() {
        return this.domainObjectServices;
    }

    public ServicesProvider getServicesProvider() {
        return this.servicesProvider;
    }

    public LocalizationProviderAbstract getLocalizationProvider() {
        return this.localizationProvider;
    }

    public ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }

    public ObjectPersistor getObjectPersistor() {
        return this.objectPersistor;
    }

    public DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public QuerySubmitter getQuerySubmitter() {
        return this.querySubmitter;
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    private static AdapterManager getRuntimeAdapterManager() {
        return RuntimeContextFromSession.getPersistenceSession().getAdapterManager();
    }

    private static UpdateNotifier getUpdateNotifier() {
        return IsisContext.getUpdateNotifier();
    }

    private static IsisTransactionManager getTransactionManager() {
        return RuntimeContextFromSession.getPersistenceSession().getTransactionManager();
    }

    private static MessageBroker getMessageBroker() {
        return IsisContext.getMessageBroker();
    }
}

