/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectfactory;

import java.lang.reflect.Modifier;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectInstantiationException;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.ObjectFactory;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;

public abstract class ObjectFactoryAbstract
implements ObjectFactory {
    private final Mode mode;

    public ObjectFactoryAbstract() {
        this(Mode.STRICT);
    }

    public ObjectFactoryAbstract(Mode mode) {
        this.mode = mode;
    }

    @Override
    public <T> T instantiate(Class<T> cls) throws ObjectInstantiationException {
        if (this.mode == Mode.STRICT && this.getServicesInjector() == null) {
            throw new IllegalStateException("ServicesInjector has not been injected into ObjectFactory");
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new ObjectInstantiationException("Cannot create an instance of an abstract class: " + cls);
        }
        T newInstance = this.doInstantiate(cls);
        if (this.getServicesInjector() != null) {
            this.getServicesInjector().injectDependencies(newInstance);
        }
        return newInstance;
    }

    public void open() {
    }

    public void close() {
    }

    protected abstract <T> T doInstantiate(Class<T> var1) throws ObjectInstantiationException;

    protected SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected ServicesInjector getServicesInjector() {
        return this.getPersistenceSession().getServicesInjector();
    }

    public static enum Mode {
        STRICT,
        RELAXED;

    }
}

