/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore;

import java.util.List;
import org.apache.isis.core.commons.config.IsisConfigurationException;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.logging.Logger;
import org.apache.isis.runtimes.dflt.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.runtimes.dflt.runtime.persistence.UnsupportedFindException;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStore;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.runtimes.dflt.runtime.transaction.ObjectPersistenceException;

public class IsisStoreLogger
extends Logger
implements ObjectStore {
    private final ObjectStore decorated;

    public IsisStoreLogger(ObjectStore decorated, String level) {
        super(level);
        this.decorated = decorated;
    }

    public IsisStoreLogger(ObjectStore decorated) {
        this.decorated = decorated;
    }

    @Override
    public CreateObjectCommand createCreateObjectCommand(ObjectAdapter object) {
        this.log("create object " + object);
        return this.decorated.createCreateObjectCommand(object);
    }

    @Override
    public void registerService(String name, Oid oid) {
        this.log("register service " + name + " as " + oid);
        this.decorated.registerService(name, oid);
    }

    @Override
    public DestroyObjectCommand createDestroyObjectCommand(ObjectAdapter object) {
        this.log("destroy object " + object);
        return this.decorated.createDestroyObjectCommand(object);
    }

    @Override
    public SaveObjectCommand createSaveObjectCommand(ObjectAdapter object) {
        this.log("save object " + object);
        return this.decorated.createSaveObjectCommand(object);
    }

    public void debugData(DebugBuilder debug) {
        this.decorated.debugData(debug);
    }

    public String debugTitle() {
        return this.decorated.debugTitle();
    }

    protected Class<?> getDecoratedClass() {
        return this.decorated.getClass();
    }

    @Override
    public ObjectAdapter[] getInstances(PersistenceQuery criteria) throws ObjectPersistenceException, UnsupportedFindException {
        this.log("get instances matching " + criteria);
        return this.decorated.getInstances(criteria);
    }

    @Override
    public ObjectAdapter getObject(Oid oid, ObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        ObjectAdapter object = this.decorated.getObject(oid, hint);
        this.log("get object for " + oid + " (of type " + hint.getShortIdentifier() + ")", object.getObject());
        return object;
    }

    @Override
    public Oid getOidForService(String name) {
        Oid oid = this.decorated.getOidForService(name);
        this.log("get OID for service " + name + ": " + oid);
        return oid;
    }

    @Override
    public boolean hasInstances(ObjectSpecification specification) throws ObjectPersistenceException {
        boolean hasInstances = this.decorated.hasInstances(specification);
        this.log("has instances of " + specification.getShortIdentifier(), "" + hasInstances);
        return hasInstances;
    }

    @Override
    public boolean isFixturesInstalled() {
        boolean isInitialized = this.decorated.isFixturesInstalled();
        this.log("is initialized: " + isInitialized);
        return isInitialized;
    }

    public void open() throws IsisConfigurationException, InstanceCreationException, ObjectPersistenceException {
        this.log("opening " + this.name());
        this.decorated.open();
    }

    @Override
    public String name() {
        return this.decorated.name();
    }

    @Override
    public void reset() {
        this.log("reset");
        this.decorated.reset();
    }

    @Override
    public void resolveField(ObjectAdapter object, ObjectAssociation field) throws ObjectPersistenceException {
        this.log("resolve eagerly object in field " + field + " of " + object);
        this.decorated.resolveField(object, field);
    }

    @Override
    public void resolveImmediately(ObjectAdapter object) throws ObjectPersistenceException {
        this.log("resolve immediately: " + object);
        this.decorated.resolveImmediately(object);
    }

    @Override
    public void execute(List<PersistenceCommand> commands) throws ObjectPersistenceException {
        this.log("execute commands");
        int i = 0;
        for (PersistenceCommand command : commands) {
            this.log("  " + i++ + " " + command);
        }
        this.decorated.execute(commands);
    }

    public void close() throws ObjectPersistenceException {
        this.log("closing " + this.decorated);
        this.decorated.close();
    }

    @Override
    public void startTransaction() {
        this.decorated.startTransaction();
    }

    @Override
    public void endTransaction() {
        this.decorated.endTransaction();
    }

    @Override
    public void abortTransaction() {
        this.decorated.abortTransaction();
    }
}

