/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore;

import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.runtimes.dflt.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.runtimes.dflt.runtime.persistence.NotPersistableException;
import org.apache.isis.runtimes.dflt.runtime.persistence.PersistenceSessionAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStorePersistence;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.ObjectStoreTransaction;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.ObjectFactory;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.OidGenerator;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.UpdateNotifier;
import org.apache.isis.runtimes.dflt.runtime.transaction.ObjectPersistenceException;
import org.apache.isis.runtimes.dflt.runtime.transaction.TransactionalClosureAbstract;
import org.apache.isis.runtimes.dflt.runtime.transaction.TransactionalClosureWithReturnAbstract;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class PersistenceSessionObjectStore
extends PersistenceSessionAbstract
implements ToPersistObjectSet {
    private static final Logger LOG = Logger.getLogger(PersistenceSessionObjectStore.class);
    private final PersistAlgorithm persistAlgorithm;
    private final ObjectStorePersistence objectStore;
    private final Map<String, Oid> services = new HashMap<String, Oid>();

    public PersistenceSessionObjectStore(PersistenceSessionFactory persistenceSessionFactory, ObjectAdapterFactory adapterFactory, ObjectFactory objectFactory, ServicesInjector servicesInjector, OidGenerator oidGenerator, AdapterManagerExtended identityMap, PersistAlgorithm persistAlgorithm, ObjectStorePersistence objectStore) {
        super(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, oidGenerator, identityMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating " + this));
        }
        Ensure.ensureThatArg((Object)persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persist algorithm required");
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"object store required");
        this.persistAlgorithm = persistAlgorithm;
        this.objectStore = objectStore;
    }

    @Override
    protected void doOpen() {
        Ensure.ensureThatState((Object)this.objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"object store required");
        Ensure.ensureThatState((Object)this.getTransactionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"transaction manager required");
        Ensure.ensureThatState((Object)this.persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"persist algorithm required");
        this.injectInto(this.objectStore);
        this.getAdapterManager().injectInto(this.objectStore);
        this.getSpecificationLoader().injectInto((Object)this.objectStore);
        this.getTransactionManager().injectInto(this.objectStore);
        this.getOidGenerator().injectInto(this.objectStore);
        this.objectStore.open();
    }

    @Override
    public boolean isFixturesInstalled() {
        PersistenceSessionFactory persistenceSessionFactory = this.getPersistenceSessionFactory();
        if (persistenceSessionFactory instanceof FixturesInstalledFlag) {
            FixturesInstalledFlag fixturesInstalledFlag = (FixturesInstalledFlag)((Object)persistenceSessionFactory);
            if (fixturesInstalledFlag.isFixturesInstalled() == null) {
                fixturesInstalledFlag.setFixturesInstalled(this.objectStore.isFixturesInstalled());
            }
            return fixturesInstalledFlag.isFixturesInstalled();
        }
        return this.objectStore.isFixturesInstalled();
    }

    @Override
    protected void doClose() {
        this.objectStore.close();
    }

    @Override
    public void testReset() {
        this.objectStore.reset();
        this.getAdapterManager().reset();
        super.testReset();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug((Object)"finalizing object manager");
    }

    @Override
    public ObjectAdapter loadObject(Oid oid, ObjectSpecification hintSpec) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)hintSpec, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectAdapter adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter != null) {
            return adapter;
        }
        return this.loadObjectFromPersistenceLayer(oid, hintSpec);
    }

    private ObjectAdapter loadObjectFromPersistenceLayer(final Oid oid, final ObjectSpecification hintSpec) {
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<ObjectAdapter>(){

            @Override
            public ObjectAdapter execute() {
                return PersistenceSessionObjectStore.this.objectStore.getObject(oid, hintSpec);
            }
        });
    }

    @Override
    public void reload(ObjectAdapter object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveImmediately(ObjectAdapter adapter) {
        AuthenticationSession authenticationSession = PersistenceSessionObjectStore.getAuthenticationSession();
        synchronized (authenticationSession) {
            ResolveState resolveState = adapter.getResolveState();
            if (!resolveState.canChangeTo(ResolveState.RESOLVING)) {
                return;
            }
            Assert.assertFalse((String)"only resolve object that is not yet resolved", (Object)adapter, (boolean)resolveState.isResolved());
            Assert.assertTrue((String)"only resolve object that is persistent", (Object)adapter, (boolean)adapter.isPersistent());
            this.resolveImmediatelyFromPersistenceLayer(adapter);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("resolved: " + adapter.getSpecification().getShortIdentifier() + " " + resolveState.code() + " " + adapter.getOid()));
            }
        }
    }

    private void resolveImmediatelyFromPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, LoadingCallbackFacet.class);
            }

            @Override
            public void execute() {
                PersistenceSessionObjectStore.this.objectStore.resolveImmediately(adapter);
            }

            @Override
            public void onSuccess() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, LoadedCallbackFacet.class);
            }

            @Override
            public void onFailure() {
            }
        });
    }

    @Override
    public void resolveField(ObjectAdapter objectAdapter, ObjectAssociation field) {
        if (field.isNotPersisted() || field.isOneToManyAssociation() || field.getSpecification().isCollectionOrIsAggregated()) {
            return;
        }
        ObjectAdapter referenceAdapter = field.get(objectAdapter);
        if (referenceAdapter == null || referenceAdapter.getResolveState().isResolved()) {
            return;
        }
        if (!referenceAdapter.isPersistent()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("resolve field " + objectAdapter.getSpecification().getShortIdentifier() + "." + field.getId() + ": " + referenceAdapter.getSpecification().getShortIdentifier() + " " + referenceAdapter.getResolveState().code() + " " + referenceAdapter.getOid()));
        }
        this.resolveFieldFromPersistenceLayer(objectAdapter, field);
    }

    private void resolveFieldFromPersistenceLayer(final ObjectAdapter objectAdapter, final ObjectAssociation field) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void execute() {
                PersistenceSessionObjectStore.this.objectStore.resolveField(objectAdapter, field);
            }
        });
    }

    @Override
    public void makePersistent(ObjectAdapter adapter) {
        if (adapter.isPersistent()) {
            throw new NotPersistableException("Object already persistent: " + adapter);
        }
        if (!adapter.getSpecification().persistability().isPersistable()) {
            throw new NotPersistableException("Object is not persistable: " + adapter);
        }
        ObjectSpecification specification = adapter.getSpecification();
        if (specification.isService()) {
            throw new NotPersistableException("Cannot persist services: " + adapter);
        }
        this.makePersistentInPersistenceLayer(adapter);
    }

    protected void makePersistentInPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
            }

            @Override
            public void execute() {
                PersistenceSessionObjectStore.this.persistAlgorithm.makePersistent(adapter, PersistenceSessionObjectStore.this);
            }

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        });
    }

    @Override
    public void objectChanged(ObjectAdapter adapter) {
        if (adapter.isTransient() || adapter.isAggregated() && adapter.getAggregateRoot().isTransient()) {
            this.addObjectChangedForPresentationLayer(adapter);
            return;
        }
        if (adapter.getResolveState().respondToChangesInPersistentObjects()) {
            if (this.isImmutable(adapter)) {
                return;
            }
            this.addObjectChangedForPersistenceLayer(adapter);
            this.addObjectChangedForPresentationLayer(adapter);
        }
        if (adapter.getResolveState().respondToChangesInPersistentObjects() || adapter.isTransient()) {
            this.addObjectChangedForPresentationLayer(adapter);
        }
    }

    private void addObjectChangedForPresentationLayer(ObjectAdapter adapter) {
        LOG.debug((Object)("object change to update presentation layer " + adapter.getOid()));
        adapter.fireChangedEvent();
        this.getUpdateNotifier().addChangedObject(adapter);
    }

    private void addObjectChangedForPersistenceLayer(final ObjectAdapter adapter) {
        LOG.debug((Object)("object change to be persisted " + adapter.getOid()));
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, UpdatingCallbackFacet.class);
            }

            @Override
            public void execute() {
                SaveObjectCommand saveObjectCommand = PersistenceSessionObjectStore.this.objectStore.createSaveObjectCommand(adapter);
                PersistenceSessionObjectStore.this.getTransactionManager().addCommand(saveObjectCommand);
            }

            @Override
            public void onSuccess() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, UpdatedCallbackFacet.class);
            }

            @Override
            public void onFailure() {
            }
        });
        this.getUpdateNotifier().addChangedObject(adapter);
    }

    @Override
    public void destroyObject(ObjectAdapter adapter) {
        if (adapter.getSpecification().isAggregated()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("destroyObject " + adapter));
        }
        this.destroyObjectInPersistenceLayer(adapter);
    }

    private void destroyObjectInPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, RemovingCallbackFacet.class);
            }

            @Override
            public void execute() {
                if (adapter.getVersion() == null) {
                    throw new ObjectPersistenceException("Object to be deleted does not have a version (maybe it should be resolved first): " + adapter);
                }
                DestroyObjectCommand command = PersistenceSessionObjectStore.this.objectStore.createDestroyObjectCommand(adapter);
                PersistenceSessionObjectStore.this.getTransactionManager().addCommand(command);
            }

            @Override
            public void onSuccess() {
                CallbackUtils.callCallback((ObjectAdapter)adapter, RemovedCallbackFacet.class);
            }

            @Override
            public void onFailure() {
            }
        });
    }

    @Override
    public void remapAsPersistent(ObjectAdapter adapter) {
        this.getAdapterManager().remapAsPersistent(adapter);
    }

    @Override
    protected ObjectAdapter[] getInstances(PersistenceQuery persistenceQuery) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getInstances matching " + persistenceQuery));
        }
        return this.getInstancesFromPersistenceLayer(persistenceQuery);
    }

    private ObjectAdapter[] getInstancesFromPersistenceLayer(final PersistenceQuery persistenceQuery) {
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<ObjectAdapter[]>(){

            @Override
            public ObjectAdapter[] execute() {
                return PersistenceSessionObjectStore.this.objectStore.getInstances(persistenceQuery);
            }

            @Override
            public void onSuccess() {
                PersistenceSessionObjectStore.this.clearAllDirty();
            }
        });
    }

    @Override
    public boolean hasInstances(ObjectSpecification specification) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("hasInstances of " + specification.getShortIdentifier()));
        }
        return this.hasInstancesFromPersistenceLayer(specification);
    }

    private boolean hasInstancesFromPersistenceLayer(final ObjectSpecification specification) {
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<Boolean>(){

            @Override
            public Boolean execute() {
                return PersistenceSessionObjectStore.this.objectStore.hasInstances(specification);
            }
        });
    }

    @Override
    protected Oid getOidForService(String name) {
        return this.getOidForServiceFromPersistenceLayer(name);
    }

    private Oid getOidForServiceFromPersistenceLayer(String name) {
        Oid oid = this.services.get(name);
        if (oid == null) {
            oid = this.objectStore.getOidForService(name);
            this.services.put(name, oid);
        }
        return oid;
    }

    @Override
    protected void registerService(String name, Oid oid) {
        this.objectStore.registerService(name, oid);
    }

    @Override
    public ObjectStoreTransactionManager getTransactionManager() {
        return (ObjectStoreTransactionManager)super.getTransactionManager();
    }

    @Override
    public void addPersistedObject(ObjectAdapter object) {
        this.getTransactionManager().addCommand(this.objectStore.createCreateObjectCommand(object));
    }

    @Override
    public void debugData(DebugBuilder debug) {
        super.debugData(debug);
        debug.appendTitle("Persistor");
        this.getTransactionManager().debugData(debug);
        debug.appendln("Persist Algorithm", (Object)this.persistAlgorithm);
        debug.appendln("Object Store", (Object)this.objectStore);
        debug.appendln();
        this.objectStore.debugData(debug);
    }

    public String debugTitle() {
        return "Object Store Persistor";
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        if (this.objectStore != null) {
            toString.append("objectStore", this.objectStore.name());
        }
        if (this.persistAlgorithm != null) {
            toString.append("persistAlgorithm", this.persistAlgorithm.name());
        }
        return toString.toString();
    }

    public ObjectStorePersistence getObjectStore() {
        return this.objectStore;
    }

    public PersistAlgorithm getPersistAlgorithm() {
        return this.persistAlgorithm;
    }

    private UpdateNotifier getUpdateNotifier() {
        return ((ObjectStoreTransaction)this.getTransactionManager().getTransaction()).getUpdateNotifier();
    }

    private static AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }
}

