/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.runtimes.dflt.runtime.persistence.NotPersistableException;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.PersistAlgorithm;

public abstract class PersistAlgorithmAbstract
implements PersistAlgorithm {
    public void init() {
    }

    public void shutdown() {
    }

    protected boolean alreadyPersistedOrNotPersistableOrServiceOrStandalone(ObjectAdapter adapter) {
        return this.objectIsStandalone(adapter) || this.objectSpecIsService(adapter) || this.alreadyPersistedOrNotPersistable(adapter);
    }

    protected boolean alreadyPersistedOrNotPersistable(ObjectAdapter adapter) {
        return adapter.isPersistent() || this.objectSpecNotPersistable(adapter);
    }

    protected void assertObjectNotPersistentAndPersistable(ObjectAdapter object) {
        if (this.alreadyPersistedOrNotPersistable(object)) {
            throw new NotPersistableException("can't make object persistent - either already persistent, or transient only: " + object);
        }
    }

    private boolean objectIsStandalone(ObjectAdapter adapter) {
        return adapter.getResolveState().isValue();
    }

    private boolean objectSpecNotPersistable(ObjectAdapter adapter) {
        return !adapter.getSpecification().persistability().isPersistable() || adapter.isAggregated();
    }

    private boolean objectSpecIsService(ObjectAdapter adapter) {
        return adapter.getSpecification().isService();
    }
}

