/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.dflt;

import java.util.List;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.apache.isis.runtimes.dflt.runtime.transaction.ObjectPersistenceException;
import org.apache.log4j.Logger;

public class DefaultPersistAlgorithm
extends PersistAlgorithmAbstract {
    private static final Logger LOG = Logger.getLogger(DefaultPersistAlgorithm.class);

    @Override
    public String name() {
        return "Simple Bottom Up Persistence Walker";
    }

    @Override
    public void makePersistent(ObjectAdapter object, ToPersistObjectSet toPersistObjectSet) {
        if (object.getSpecification().isCollection()) {
            LOG.debug((Object)("persist " + object));
            if (object.getResolveState() == ResolveState.GHOST) {
                object.changeState(ResolveState.RESOLVING);
                object.changeState(ResolveState.RESOLVED);
            } else if (object.getResolveState() == ResolveState.TRANSIENT) {
                object.changeState(ResolveState.RESOLVED);
            }
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)object);
            for (ObjectAdapter element : facet.iterable(object)) {
                this.persist(element, toPersistObjectSet);
            }
        } else {
            this.assertObjectNotPersistentAndPersistable(object);
            this.persist(object, toPersistObjectSet);
        }
    }

    protected void persist(ObjectAdapter object, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistableOrServiceOrStandalone(object)) {
            return;
        }
        List fields = object.getSpecification().getAssociations();
        if (!object.getSpecification().isEncodeable() && fields.size() > 0) {
            LOG.debug((Object)("make persistent " + object));
            CallbackUtils.callCallback((ObjectAdapter)object, PersistingCallbackFacet.class);
            toPersistObjectSet.remapAsPersistent(object);
            object.changeState(ResolveState.SERIALIZING_RESOLVED);
            for (int i = 0; i < fields.size(); ++i) {
                ObjectAssociation field = (ObjectAssociation)fields.get(i);
                if (field.isNotPersisted()) continue;
                if (field.isOneToManyAssociation()) {
                    ObjectAdapter collection = field.get(object);
                    if (collection == null) {
                        throw new ObjectPersistenceException("Collection " + field.getName() + " does not exist in " + object.getSpecification().getFullIdentifier());
                    }
                    this.makePersistent(collection, toPersistObjectSet);
                    continue;
                }
                ObjectAdapter fieldValue = field.get(object);
                if (fieldValue == null) continue;
                this.persist(fieldValue, toPersistObjectSet);
            }
            toPersistObjectSet.addPersistedObject(object);
            CallbackUtils.callCallback((ObjectAdapter)object, PersistedCallbackFacet.class);
            object.changeState(ResolveState.SERIALIZING_RESOLVED.getEndState());
        }
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

