/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.topdown;

import java.util.Enumeration;
import java.util.List;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.apache.isis.runtimes.dflt.runtime.transaction.ObjectPersistenceException;
import org.apache.log4j.Logger;

public class TopDownPersistAlgorithm
extends PersistAlgorithmAbstract {
    private static final Logger LOG = Logger.getLogger(TopDownPersistAlgorithm.class);

    @Override
    public void makePersistent(ObjectAdapter object, ToPersistObjectSet toPersistObjectSet) {
        if (object.getSpecification().isCollection()) {
            this.makeCollectionPersistent(object, toPersistObjectSet);
        } else {
            this.makeObjectPersistent(object, toPersistObjectSet);
        }
    }

    private void makeObjectPersistent(ObjectAdapter object, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistableOrServiceOrStandalone(object)) {
            LOG.warn((Object)("can't make object persistent - either already persistent, or transient only: " + object));
            return;
        }
        List fields = object.getSpecification().getAssociations();
        if (!object.getSpecification().isEncodeable() && fields.size() > 0) {
            LOG.info((Object)("persist " + object));
            CallbackUtils.callCallback((ObjectAdapter)object, PersistingCallbackFacet.class);
            toPersistObjectSet.remapAsPersistent(object);
            toPersistObjectSet.addPersistedObject(object);
            CallbackUtils.callCallback((ObjectAdapter)object, PersistedCallbackFacet.class);
            for (int i = 0; i < fields.size(); ++i) {
                ObjectAssociation field = (ObjectAssociation)fields.get(i);
                if (field.isNotPersisted()) continue;
                if (field instanceof OneToManyAssociation) {
                    ObjectAdapter collection = field.get(object);
                    if (collection == null) {
                        throw new ObjectPersistenceException("Collection " + field.getName() + " does not exist in " + object.getSpecification().getFullIdentifier());
                    }
                    this.makePersistent(collection, toPersistObjectSet);
                    continue;
                }
                ObjectAdapter fieldValue = field.get(object);
                if (fieldValue == null) continue;
                this.makePersistent(fieldValue, toPersistObjectSet);
            }
        }
    }

    private void makeCollectionPersistent(ObjectAdapter collection, ToPersistObjectSet toPersistObjectSet) {
        LOG.info((Object)("persist " + collection));
        if (collection.getResolveState() == ResolveState.TRANSIENT) {
            collection.changeState(ResolveState.RESOLVED);
        }
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
        Enumeration elements = facet.elements(collection);
        while (elements.hasMoreElements()) {
            this.makePersistent((ObjectAdapter)elements.nextElement(), toPersistObjectSet);
        }
    }

    @Override
    public String name() {
        return "Simple Top Down Persistence Walker";
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

