/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.twopass;

import java.util.Enumeration;
import java.util.List;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackUtils;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.PersistAlgorithmAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.apache.log4j.Logger;

public class TwoPassPersistAlgorithm
extends PersistAlgorithmAbstract {
    private static final Logger LOG = Logger.getLogger(TwoPassPersistAlgorithm.class);

    @Override
    public String name() {
        return "Two pass,  bottom up persistence walker";
    }

    @Override
    public void makePersistent(ObjectAdapter object, ToPersistObjectSet toPersistObjectSet) {
        if (object.getSpecification().isCollection()) {
            this.makeCollectionPersistent(object, toPersistObjectSet);
        } else {
            this.makeObjectPersistent(object, toPersistObjectSet);
        }
    }

    private void makeObjectPersistent(ObjectAdapter object, ToPersistObjectSet toPersistObjectSet) {
        if (this.alreadyPersistedOrNotPersistableOrServiceOrStandalone(object)) {
            return;
        }
        List fields = object.getSpecification().getAssociations();
        if (!object.getSpecification().isEncodeable() && fields.size() > 0) {
            ObjectAssociation field;
            int i;
            LOG.info((Object)("persist " + object));
            CallbackUtils.callCallback((ObjectAdapter)object, PersistingCallbackFacet.class);
            toPersistObjectSet.remapAsPersistent(object);
            for (i = 0; i < fields.size(); ++i) {
                ObjectAdapter fieldValue;
                field = (ObjectAssociation)fields.get(i);
                if (field.isNotPersisted() || field.isOneToManyAssociation() || (fieldValue = field.get(object)) == null) continue;
                this.makePersistent(fieldValue, toPersistObjectSet);
            }
            for (i = 0; i < fields.size(); ++i) {
                field = (ObjectAssociation)fields.get(i);
                if (field.isNotPersisted() || !(field instanceof OneToManyAssociation)) continue;
                ObjectAdapter collection = field.get(object);
                this.makeCollectionPersistent(collection, toPersistObjectSet);
            }
            toPersistObjectSet.addPersistedObject(object);
            CallbackUtils.callCallback((ObjectAdapter)object, PersistedCallbackFacet.class);
        }
    }

    private void makeCollectionPersistent(ObjectAdapter collection, ToPersistObjectSet toPersistObjectSet) {
        LOG.info((Object)("persist " + collection));
        if (collection.getResolveState() == ResolveState.TRANSIENT) {
            collection.changeState(ResolveState.RESOLVED);
        }
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
        Enumeration elements = facet.elements(collection);
        while (elements.hasMoreElements()) {
            this.makePersistent((ObjectAdapter)elements.nextElement(), toPersistObjectSet);
        }
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        return toString.toString();
    }
}

