/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.MessageBroker;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.UpdateNotifier;
import org.apache.isis.runtimes.dflt.runtime.transaction.IsisTransactionAbstract;
import org.apache.log4j.Logger;

public class ObjectStoreTransaction
extends IsisTransactionAbstract {
    private static final Logger LOG = Logger.getLogger(ObjectStoreTransaction.class);
    private final ObjectStoreTransactionManagement objectStore;
    private final List<PersistenceCommand> commands = new ArrayList<PersistenceCommand>();

    public ObjectStoreTransaction(IsisTransactionManager transactionManager, MessageBroker messageBroker, UpdateNotifier updateNotifier, ObjectStoreTransactionManagement objectStore) {
        super(transactionManager, messageBroker, updateNotifier);
        this.objectStore = objectStore;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new transaction " + this));
        }
    }

    public void addCommand(PersistenceCommand command) {
        if (command == null) {
            return;
        }
        ObjectAdapter onObject = command.onObject();
        if (command instanceof SaveObjectCommand) {
            if (this.alreadyHasCreate(onObject) || this.alreadyHasSave(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ignored command as object already created/saved" + command));
                }
                return;
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ignored command " + command + " as object no longer exists"));
                }
                return;
            }
        }
        if (command instanceof DestroyObjectCommand) {
            if (this.alreadyHasCreate(onObject)) {
                this.removeCreate(onObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ignored both create and destroy command " + command));
                }
                return;
            }
            if (this.alreadyHasSave(onObject)) {
                this.removeSave(onObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("removed prior save command " + command));
                }
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ignored command " + command + " as command already recorded"));
                }
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("add command " + command));
        }
        this.commands.add(command);
    }

    @Override
    public void doAbort() {
    }

    @Override
    public void doFlush() {
        if (this.commands.size() > 0) {
            this.objectStore.execute(Collections.unmodifiableList(this.commands));
            for (PersistenceCommand command : this.commands) {
                if (!(command instanceof DestroyObjectCommand)) continue;
                ObjectAdapter adapter = command.onObject();
                adapter.setOptimisticLock(null);
                adapter.changeState(ResolveState.DESTROYED);
            }
            this.commands.clear();
        }
    }

    private boolean alreadyHasCommand(Class<?> commandClass, ObjectAdapter onObject) {
        return this.getCommand(commandClass, onObject) != null;
    }

    private boolean alreadyHasCreate(ObjectAdapter onObject) {
        return this.alreadyHasCommand(CreateObjectCommand.class, onObject);
    }

    private boolean alreadyHasDestroy(ObjectAdapter onObject) {
        return this.alreadyHasCommand(DestroyObjectCommand.class, onObject);
    }

    private boolean alreadyHasSave(ObjectAdapter onObject) {
        return this.alreadyHasCommand(SaveObjectCommand.class, onObject);
    }

    private PersistenceCommand getCommand(Class<?> commandClass, ObjectAdapter onObject) {
        for (PersistenceCommand command : this.commands) {
            if (!command.onObject().equals(onObject) || !commandClass.isAssignableFrom(command.getClass())) continue;
            return command;
        }
        return null;
    }

    private void removeCommand(Class<?> commandClass, ObjectAdapter onObject) {
        PersistenceCommand toDelete = this.getCommand(commandClass, onObject);
        this.commands.remove(toDelete);
    }

    private void removeCreate(ObjectAdapter onObject) {
        this.removeCommand(CreateObjectCommand.class, onObject);
    }

    private void removeSave(ObjectAdapter onObject) {
        this.removeCommand(SaveObjectCommand.class, onObject);
    }

    @Override
    protected ToString appendTo(ToString str) {
        super.appendTo(str);
        str.append("commands", this.commands.size());
        return str;
    }
}

