/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction;

import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.ObjectStoreTransaction;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionTransactionManagement;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.MessageBroker;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.UpdateNotifier;
import org.apache.isis.runtimes.dflt.runtime.transaction.IsisTransactionManagerAbstract;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ObjectStoreTransactionManager
extends IsisTransactionManagerAbstract<ObjectStoreTransaction> {
    private static final Logger LOG = Logger.getLogger(ObjectStoreTransactionManager.class);
    private final PersistenceSessionTransactionManagement objectPersistor;
    private final ObjectStoreTransactionManagement objectStore;
    int transactionLevel;

    public ObjectStoreTransactionManager(PersistenceSessionTransactionManagement objectPersistor, ObjectStoreTransactionManagement objectStore) {
        this.objectPersistor = objectPersistor;
        this.objectStore = objectStore;
    }

    @Override
    public void startTransaction() {
        boolean noneInProgress = false;
        if (this.getTransaction() == null || ((ObjectStoreTransaction)this.getTransaction()).getState().isComplete()) {
            noneInProgress = true;
            this.createTransaction();
            this.transactionLevel = 0;
            this.objectStore.startTransaction();
        }
        ++this.transactionLevel;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("startTransaction: level " + (this.transactionLevel - 1) + "->" + this.transactionLevel + (noneInProgress ? " (no transaction in progress or was previously completed; transaction created)" : "")));
        }
    }

    @Override
    public boolean flushTransaction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"flushTransaction");
        }
        if (this.getTransaction() != null) {
            this.objectPersistor.objectChangedAllDirty();
            ((ObjectStoreTransaction)this.getTransaction()).flush();
        }
        return false;
    }

    @Override
    public void endTransaction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("endTransaction: level " + this.transactionLevel + "->" + (this.transactionLevel - 1)));
        }
        --this.transactionLevel;
        if (this.transactionLevel == 0) {
            LOG.debug((Object)"endTransaction: committing");
            this.objectPersistor.objectChangedAllDirty();
            ((ObjectStoreTransaction)this.getTransaction()).commit();
            this.objectStore.endTransaction();
        } else if (this.transactionLevel < 0) {
            LOG.error((Object)("endTransaction: transactionLevel=" + this.transactionLevel));
            this.transactionLevel = 0;
            throw new IllegalStateException(" no transaction running to end (transactionLevel < 0)");
        }
    }

    @Override
    public void abortTransaction() {
        if (this.getTransaction() != null) {
            ((ObjectStoreTransaction)this.getTransaction()).abort();
            this.transactionLevel = 0;
            this.objectStore.abortTransaction();
        }
    }

    public void addCommand(PersistenceCommand command) {
        ((ObjectStoreTransaction)this.getTransaction()).addCommand(command);
    }

    @Override
    protected ObjectStoreTransaction createTransaction(MessageBroker messageBroker, UpdateNotifier updateNotifier) {
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)updateNotifier, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        return new ObjectStoreTransaction(this, messageBroker, updateNotifier, this.objectStore);
    }
}

