/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.oidgenerator.simple;

import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.matchers.IsisMatchers;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.stringable.OidStringifier;
import org.apache.isis.core.metamodel.adapter.oid.stringable.directly.OidStringifierDirect;
import org.apache.isis.runtimes.dflt.runtime.persistence.oidgenerator.OidGeneratorAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.oidgenerator.simple.SerialOid;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class SimpleOidGenerator
extends OidGeneratorAbstract {
    private long persistentSerialNumber;
    private long transientSerialNumber;
    private long aggregatedId;

    public SimpleOidGenerator() {
        this(1L);
    }

    public SimpleOidGenerator(long seed) {
        this(seed, Long.MIN_VALUE + seed);
    }

    public SimpleOidGenerator(Memento memento) {
        this(memento.getPersistentSerialNumber(), memento.getTransientSerialNumber());
    }

    private SimpleOidGenerator(long persistentSerialNumber, long transientSerialNumber) {
        super((OidStringifier)new OidStringifierDirect(SerialOid.class));
        Ensure.ensureThatArg((Object)persistentSerialNumber, (Matcher)CoreMatchers.is((Matcher)IsisMatchers.greaterThan((Comparable)Long.valueOf(0L))));
        this.persistentSerialNumber = persistentSerialNumber;
        this.transientSerialNumber = transientSerialNumber;
    }

    public String name() {
        return "Simple Serial OID Generator";
    }

    public synchronized SerialOid createTransientOid(Object object) {
        return SerialOid.createTransient(this.transientSerialNumber--);
    }

    @Override
    public synchronized void convertTransientToPersistentOid(Oid oid) {
        if (!(oid instanceof SerialOid)) {
            throw new IllegalArgumentException("Oid is not a SerialOid");
        }
        SerialOid serialOid = (SerialOid)oid;
        serialOid.setId(this.persistentSerialNumber++);
        serialOid.makePersistent();
    }

    @Override
    public String createAggregateId(Object pojo) {
        return Long.toHexString(this.aggregatedId++);
    }

    public Memento getMemento() {
        return new Memento(this.persistentSerialNumber, this.transientSerialNumber);
    }

    public void resetTo(Memento memento) {
        this.persistentSerialNumber = memento.getPersistentSerialNumber();
        this.transientSerialNumber = memento.getTransientSerialNumber();
    }

    public void debugData(DebugBuilder debug) {
        debug.appendln("Persistent", this.persistentSerialNumber);
        debug.appendln("Transient", this.transientSerialNumber);
    }

    public String debugTitle() {
        return this.name();
    }

    public static class Memento {
        private final long persistentSerialNumber;
        private final long transientSerialNumber;

        Memento(long persistentSerialNumber, long transientSerialNumber) {
            this.persistentSerialNumber = persistentSerialNumber;
            this.transientSerialNumber = transientSerialNumber;
        }

        public long getTransientSerialNumber() {
            return this.transientSerialNumber;
        }

        public long getPersistentSerialNumber() {
            return this.persistentSerialNumber;
        }
    }
}

