/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.query;

import java.io.IOException;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceQuery;

public abstract class PersistenceQueryAbstract
implements PersistenceQuery,
Encodable {
    private final ObjectSpecification specification;

    public PersistenceQueryAbstract(ObjectSpecification specification) {
        this.specification = specification;
        this.initialized();
    }

    protected PersistenceQueryAbstract(DataInputExtended input) throws IOException {
        String specName = input.readUTF();
        this.specification = PersistenceQueryAbstract.getSpecificationLoader().loadSpecification(specName);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.specification.getFullIdentifier());
    }

    private void initialized() {
    }

    @Override
    public ObjectSpecification getSpecification() {
        return this.specification;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceQueryAbstract other = (PersistenceQueryAbstract)obj;
        return !(this.specification == null ? other.specification != null : !this.specification.equals(other.specification));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + 1231;
        result = 31 * result + (this.specification == null ? 0 : this.specification.hashCode());
        return result;
    }

    protected static SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

