/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.query;

import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.runtimes.dflt.runtime.persistence.query.PersistenceQueryBuiltInAbstract;

public class PersistenceQueryFindByPattern
extends PersistenceQueryBuiltInAbstract {
    private final ObjectAdapter pattern;

    public ObjectAdapter getPattern() {
        return this.pattern;
    }

    public PersistenceQueryFindByPattern(ObjectSpecification specification, ObjectAdapter pattern) {
        super(specification);
        this.pattern = pattern;
    }

    @Override
    public boolean matches(ObjectAdapter object) {
        ObjectSpecification requiredSpec = this.pattern.getSpecification();
        ObjectSpecification objectSpec = object.getSpecification();
        return objectSpec.equals(requiredSpec) && this.matchesPattern(this.pattern, object);
    }

    private boolean matchesPattern(ObjectAdapter pattern, ObjectAdapter instance) {
        ObjectAdapter object = instance;
        ObjectSpecification nc = object.getSpecification();
        List fields = nc.getAssociations();
        for (int f = 0; f < fields.size(); ++f) {
            ObjectAdapter search;
            ObjectAdapter reqd;
            ObjectAssociation fld = (ObjectAssociation)fields.get(f);
            if (fld.isNotPersisted() || !fld.isOneToOneAssociation()) continue;
            if (fld.getSpecification().isCollectionOrIsAggregated()) {
                if (fld.isEmpty(pattern)) continue;
                reqd = fld.get(pattern);
                search = fld.get(object);
                if (search == null) {
                    return false;
                }
                String r = reqd.titleString().toLowerCase();
                String s = search.titleString().toLowerCase();
                if (s.indexOf(r) != -1) continue;
                return false;
            }
            if (!fld.isOneToOneAssociation() || (reqd = fld.get(pattern)) == null) continue;
            search = fld.get(object);
            if (search == null) {
                return false;
            }
            if (reqd == search) continue;
            return false;
        }
        return true;
    }
}

