/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.query;

import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.runtime.persistence.query.PersistenceQueryBuiltInAbstract;

public class PersistenceQueryFindByTitle
extends PersistenceQueryBuiltInAbstract {
    private final String title;

    public PersistenceQueryFindByTitle(ObjectSpecification specification, String title) {
        super(specification);
        this.title = title == null ? "" : title.toLowerCase();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean matches(ObjectAdapter object) {
        String titleString = object.titleString();
        return this.matches(titleString);
    }

    public boolean matches(String titleString) {
        String objectTitle = titleString.toLowerCase();
        return objectTitle.indexOf(this.title) >= 0;
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("spec", this.getSpecification().getShortIdentifier());
        str.append("title", this.title);
        return str.toString();
    }
}

