/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.query;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.runtime.persistence.query.PersistenceQueryAbstract;

public class PersistenceQueryFindUsingApplibQueryDefault
extends PersistenceQueryAbstract {
    private final String queryName;
    private final QueryCardinality cardinality;
    private final Map<String, ObjectAdapter> argumentsAdaptersByParameterName;

    public PersistenceQueryFindUsingApplibQueryDefault(ObjectSpecification specification, String queryName, Map<String, ObjectAdapter> argumentsAdaptersByParameterName, QueryCardinality cardinality) {
        super(specification);
        this.queryName = queryName;
        this.cardinality = cardinality;
        this.argumentsAdaptersByParameterName = argumentsAdaptersByParameterName;
        this.initialized();
    }

    public PersistenceQueryFindUsingApplibQueryDefault(DataInputExtended input) throws IOException {
        super(input);
        this.queryName = input.readUTF();
        this.cardinality = QueryCardinality.valueOf((String)input.readUTF());
        this.argumentsAdaptersByParameterName = new HashMap<String, ObjectAdapter>();
        this.initialized();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeUTF(this.queryName);
        output.writeUTF(this.cardinality.name());
    }

    private void initialized() {
    }

    public String getQueryName() {
        return this.queryName;
    }

    public Map<String, ObjectAdapter> getArgumentsAdaptersByParameterName() {
        return Collections.unmodifiableMap(this.argumentsAdaptersByParameterName);
    }

    public QueryCardinality getCardinality() {
        return this.cardinality;
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("spec", this.getSpecification().getShortIdentifier());
        return str.toString();
    }
}

