/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.persistence.query;

import java.io.IOException;
import org.apache.isis.applib.query.Query;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.runtime.persistence.query.PersistenceQueryAbstract;

public class PersistenceQueryFindUsingApplibQuerySerializable
extends PersistenceQueryAbstract {
    private final Query<?> query;
    private final QueryCardinality cardinality;

    public PersistenceQueryFindUsingApplibQuerySerializable(ObjectSpecification specification, Query<?> query, QueryCardinality cardinality) {
        super(specification);
        this.query = query;
        this.cardinality = cardinality;
        this.initialized();
    }

    public PersistenceQueryFindUsingApplibQuerySerializable(DataInputExtended input) throws IOException {
        super(input);
        this.query = (Query)input.readSerializable(Query.class);
        this.cardinality = QueryCardinality.valueOf((String)input.readUTF());
        this.initialized();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeSerializable(this.query);
        output.writeUTF(this.cardinality.name());
    }

    private void initialized() {
    }

    public Query getApplibQuery() {
        return this.query;
    }

    public QueryCardinality getCardinality() {
        return this.cardinality;
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("spec", this.getSpecification().getShortIdentifier());
        str.append("query", this.query.getDescription());
        return str.toString();
    }
}

