/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderDefault;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderPrimer;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookup;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.IsisViewerInstaller;
import org.apache.isis.runtimes.dflt.runtime.installers.InstallerLookupDefault;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.isis.runtimes.dflt.runtime.system.IsisSystem;
import org.apache.isis.runtimes.dflt.runtime.system.IsisSystemFactory;
import org.apache.isis.runtimes.dflt.runtime.systemusinginstallers.IsisSystemThatUsesInstallersFactory;
import org.apache.isis.runtimes.dflt.runtime.viewer.IsisViewer;

public class IsisModule
extends AbstractModule {
    private final DeploymentType deploymentType;
    private final InstallerLookup installerLookup;
    private final IsisConfigurationBuilder isisConfigurationBuilder;
    private final List<IsisConfigurationBuilderPrimer> isisConfigurationBuilderPrimers = Lists.newArrayList();
    private final List<String> viewerNames = Lists.newArrayList();

    private static InstallerLookupDefault defaultInstallerLookup() {
        return new InstallerLookupDefault();
    }

    private static IsisConfigurationBuilderDefault defaultConfigurationBuider() {
        return new IsisConfigurationBuilderDefault();
    }

    public IsisModule(DeploymentType deploymentType) {
        this(deploymentType, (IsisConfigurationBuilder)IsisModule.defaultConfigurationBuider(), IsisModule.defaultInstallerLookup());
    }

    public IsisModule(DeploymentType deploymentType, IsisConfigurationBuilder isisConfigurationBuilder) {
        this(deploymentType, isisConfigurationBuilder, IsisModule.defaultInstallerLookup());
    }

    public IsisModule(DeploymentType deploymentType, InstallerLookup installerLookup) {
        this(deploymentType, (IsisConfigurationBuilder)IsisModule.defaultConfigurationBuider(), installerLookup);
    }

    public IsisModule(DeploymentType deploymentType, IsisConfigurationBuilder isisConfigurationBuilder, InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
        this.isisConfigurationBuilder = isisConfigurationBuilder;
        this.deploymentType = deploymentType;
    }

    @Provides
    @Singleton
    private DeploymentType provideDeploymentsType() {
        return this.deploymentType;
    }

    @Provides
    @Singleton
    private IsisConfigurationBuilder providesConfigurationBuilder() {
        return this.primeConfiguration(this.isisConfigurationBuilder);
    }

    private IsisConfigurationBuilder primeConfiguration(IsisConfigurationBuilder configBuilder) {
        for (IsisConfigurationBuilderPrimer isisConfigurationBuilderPrimer : this.isisConfigurationBuilderPrimers) {
            isisConfigurationBuilderPrimer.primeConfigurationBuilder(configBuilder);
        }
        return configBuilder;
    }

    @Provides
    @Singleton
    @Inject
    private InstallerLookup providesInstallerLookup(IsisConfigurationBuilder configBuilder) {
        configBuilder.injectInto((Object)this.installerLookup);
        this.installerLookup.init();
        return this.installerLookup;
    }

    public void addConfigurationPrimers(List<? extends IsisConfigurationBuilderPrimer> isisConfigurationBuilderPrimers) {
        this.isisConfigurationBuilderPrimers.addAll(isisConfigurationBuilderPrimers);
    }

    public void addViewerNames(List<String> viewerNames) {
        this.viewerNames.addAll(viewerNames);
    }

    protected void configure() {
        this.requireBinding(DeploymentType.class);
        this.requireBinding(IsisConfigurationBuilder.class);
        this.requireBinding(InstallerLookup.class);
    }

    @Provides
    @Inject
    @Singleton
    private IsisSystemFactory provideIsisSystemFactory(InstallerLookup installerLookup) {
        IsisSystemThatUsesInstallersFactory systemFactory = new IsisSystemThatUsesInstallersFactory(installerLookup);
        systemFactory.init();
        return systemFactory;
    }

    @Provides
    @Inject
    @Singleton
    private IsisSystem provideIsisSystem(DeploymentType deploymentType, IsisSystemFactory systemFactory) {
        IsisSystem system = systemFactory.createSystem(deploymentType);
        system.init();
        return system;
    }

    @Provides
    @Inject
    @Singleton
    private ViewerList lookupViewers(InstallerLookup installerLookup, DeploymentType deploymentType) {
        ArrayList viewersToStart = Lists.newArrayList(this.viewerNames);
        deploymentType.addDefaultViewer(viewersToStart);
        ArrayList viewers = Lists.newArrayList();
        for (String requestedViewer : viewersToStart) {
            IsisViewerInstaller viewerInstaller = installerLookup.viewerInstaller(requestedViewer);
            IsisViewer viewer = viewerInstaller.createViewer();
            viewers.add(viewer);
        }
        return new ViewerList(viewers);
    }

    public static class ViewerList {
        private final List<IsisViewer> viewers;

        public ViewerList(List<IsisViewer> viewers) {
            this.viewers = Collections.unmodifiableList(viewers);
        }

        public List<IsisViewer> getViewers() {
            return this.viewers;
        }
    }
}

