/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.isis.applib.maybe.Maybe;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderDefault;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandler;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookup;
import org.apache.isis.runtimes.dflt.runtime.installers.InstallerLookupDefault;
import org.apache.isis.runtimes.dflt.runtime.runner.IsisBootstrapper;
import org.apache.isis.runtimes.dflt.runtime.runner.IsisModule;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerAdditionalProperty;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerConfiguration;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerConnector;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerDebug;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerDeploymentType;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerDiagnostics;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerFixture;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerHelp;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerNoSplash;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerPersistor;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerQuiet;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerReflector;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerUserProfileStore;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerVerbose;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerVersion;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerViewer;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionValidator;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionValidatorForConnector;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionValidatorForPersistor;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionValidatorForViewers;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;

public class IsisRunner {
    private final IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer();
    private final String[] args;
    private final OptionHandlerDeploymentType optionHandlerDeploymentType;
    private final InstallerLookup installerLookup;
    private final OptionHandlerViewer optionHandlerViewer;
    private final List<OptionHandler> optionHandlers = Lists.newArrayList();
    private final List<OptionValidator> validators = Lists.newArrayList();
    private IsisConfigurationBuilder isisConfigurationBuilder = new IsisConfigurationBuilderDefault();
    private Injector globalInjector;

    public IsisRunner(String[] args, OptionHandlerDeploymentType optionHandlerDeploymentType) {
        this.args = args;
        this.optionHandlerDeploymentType = optionHandlerDeploymentType;
        this.loggingConfigurer.configureLogging(this.determineConfigDirectory(), args);
        this.installerLookup = new InstallerLookupDefault();
        this.addOptionHandler((OptionHandler)optionHandlerDeploymentType);
        this.optionHandlerViewer = this.addStandardOptionHandlersAndValidators(this.installerLookup);
    }

    private String determineConfigDirectory() {
        if (new File("src/main/webapp/WEB-INF").exists()) {
            return "src/main/webapp/WEB-INF";
        }
        return "config";
    }

    public final boolean addOptionHandler(OptionHandler optionHandler) {
        return this.optionHandlers.add(optionHandler);
    }

    public void addValidator(OptionValidator validator) {
        this.validators.add(validator);
    }

    public void setConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        this.isisConfigurationBuilder = isisConfigurationBuilder;
    }

    public final boolean parseAndValidate() {
        BootPrinter printer;
        Options options = this.createOptions();
        return this.parseOptions(options, printer = new BootPrinter(this.getClass())) && this.validateOptions(options, printer);
    }

    private Options createOptions() {
        Options options = new Options();
        for (OptionHandler optionHandler : this.optionHandlers) {
            optionHandler.addOption(options);
        }
        return options;
    }

    private boolean parseOptions(Options options, BootPrinter printer) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine commandLine = parser.parse(options, this.args);
            for (OptionHandler optionHandler : this.optionHandlers) {
                if (optionHandler.handle(commandLine, printer, options)) continue;
                return false;
            }
        }
        catch (ParseException e) {
            printer.printErrorMessage(e.getMessage());
            printer.printHelp(options);
            return false;
        }
        return true;
    }

    private boolean validateOptions(Options options, BootPrinter printer) {
        DeploymentType deploymentType = this.optionHandlerDeploymentType.getDeploymentType();
        for (OptionValidator validator : this.validators) {
            Maybe<String> errorMessage = validator.validate(deploymentType);
            if (!errorMessage.isSet()) continue;
            printer.printErrorAndHelp(options, (String)errorMessage.get(), new Object[0]);
            return false;
        }
        return true;
    }

    public final void bootstrap(IsisBootstrapper bootstrapper) {
        DeploymentType deploymentType = this.optionHandlerDeploymentType.getDeploymentType();
        this.globalInjector = this.createGuiceInjector(deploymentType, this.isisConfigurationBuilder, this.installerLookup, this.optionHandlers);
        bootstrapper.bootstrap(this.globalInjector);
    }

    private Injector createGuiceInjector(DeploymentType deploymentType, IsisConfigurationBuilder isisConfigurationBuilder, InstallerLookup installerLookup, List<OptionHandler> optionHandlers) {
        IsisModule isisModule = new IsisModule(deploymentType, isisConfigurationBuilder, installerLookup);
        isisModule.addConfigurationPrimers(optionHandlers);
        isisModule.addViewerNames(this.optionHandlerViewer.getViewerNames());
        return Guice.createInjector((Module[])new Module[]{isisModule});
    }

    public final List<OptionHandler> getOptionHandlers() {
        return Collections.unmodifiableList(this.optionHandlers);
    }

    private OptionHandlerViewer addStandardOptionHandlersAndValidators(InstallerLookup installerLookup) {
        this.addOptionHandler((OptionHandler)new OptionHandlerConfiguration());
        OptionHandlerConnector optionHandlerClientConnection = new OptionHandlerConnector(installerLookup);
        this.addOptionHandler((OptionHandler)optionHandlerClientConnection);
        OptionHandlerPersistor optionHandlerPersistor = new OptionHandlerPersistor(installerLookup);
        this.addOptionHandler((OptionHandler)optionHandlerPersistor);
        OptionHandlerViewer optionHandlerViewer = new OptionHandlerViewer(installerLookup);
        this.addOptionHandler((OptionHandler)optionHandlerViewer);
        this.addOptionHandler((OptionHandler)new OptionHandlerReflector(installerLookup));
        this.addOptionHandler((OptionHandler)new OptionHandlerUserProfileStore(installerLookup));
        this.addOptionHandler((OptionHandler)new OptionHandlerFixture());
        this.addOptionHandler((OptionHandler)new OptionHandlerNoSplash());
        this.addOptionHandler((OptionHandler)new OptionHandlerAdditionalProperty());
        this.addOptionHandler((OptionHandler)new OptionHandlerDebug());
        this.addOptionHandler((OptionHandler)new OptionHandlerDiagnostics());
        this.addOptionHandler((OptionHandler)new OptionHandlerQuiet());
        this.addOptionHandler((OptionHandler)new OptionHandlerVerbose());
        this.addOptionHandler((OptionHandler)new OptionHandlerHelp());
        this.addOptionHandler((OptionHandler)new OptionHandlerVersion());
        this.addValidator(new OptionValidatorForViewers(optionHandlerViewer));
        this.addValidator(new OptionValidatorForConnector(optionHandlerClientConnection));
        this.addValidator(new OptionValidatorForPersistor(optionHandlerPersistor));
        return optionHandlerViewer;
    }
}

