/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.lang.ListUtils;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerRepository;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.IsisViewerInstaller;

public class OptionHandlerConnector
extends OptionHandlerAbstract {
    private final InstallerRepository installerRepository;
    private List<String> connectorNames;

    public OptionHandlerConnector(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    public void addOption(Options options) {
        Object[] connectors = this.installerRepository.getInstallers(IsisViewerInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"connector");
        OptionBuilder.withDescription((String)("connector to use for client requests, or for server to listen on: " + this.availableInstallers(connectors)));
        Option option = OptionBuilder.create((String)"x");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.connectorNames = this.getOptionValues(commandLine, "x");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        isisConfigurationBuilder.add("isis.connector", ListUtils.listToString(this.connectorNames));
    }

    public List<String> getConnectorNames() {
        return this.connectorNames;
    }
}

