/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;

public abstract class OptionHandlerDeploymentType
extends OptionHandlerAbstract {
    private final DeploymentType defaultDeploymentType;
    private final String types;
    private DeploymentType deploymentType;

    public OptionHandlerDeploymentType(DeploymentType defaultDeploymentType, String types) {
        this.defaultDeploymentType = defaultDeploymentType;
        this.types = types;
    }

    public void addOption(Options options) {
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.withDescription((String)("deployment type: " + this.types));
        Option option = OptionBuilder.create((String)"t");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        String deploymentTypeName = commandLine.getOptionValue("t");
        if (deploymentTypeName == null) {
            this.deploymentType = this.defaultDeploymentType;
            return true;
        }
        this.deploymentType = DeploymentType.lookup(deploymentTypeName.toUpperCase());
        if (this.deploymentType != null) {
            return true;
        }
        bootPrinter.printErrorAndHelp(options, "Unable to determine deployment type", new Object[0]);
        return false;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        String type = this.deploymentType.nameLowerCase();
        isisConfigurationBuilder.addConfigurationResource(type + ".properties", NotFoundPolicy.CONTINUE);
        isisConfigurationBuilder.add("isis.deploymentType", this.deploymentType.name());
    }
}

