/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerRepository;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;

public class OptionHandlerPersistor
extends OptionHandlerAbstract {
    private final InstallerRepository installerRepository;
    private String persistorName;

    public OptionHandlerPersistor(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    public void addOption(Options options) {
        Object[] objectPersistenceMechanisms = this.installerRepository.getInstallers(PersistenceMechanismInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"persistor");
        OptionBuilder.withDescription((String)("object persistence mechanism to use (ignored if type is prototype or client): " + this.availableInstallers(objectPersistenceMechanisms) + "; or class name"));
        Option option = OptionBuilder.create((String)"r");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.persistorName = commandLine.getOptionValue("r");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        isisConfigurationBuilder.add("isis.persistor", this.persistorName);
    }

    public String getPersistorName() {
        return this.persistorName;
    }
}

